<?php

namespace Modules\MenuBuilder\Database\Seeders;

use Illuminate\Database\Seeder;

class MenuItemsTableWithoutDummyDataSeeder extends Seeder
{
    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run()
    {
        \DB::table('menu_items')->delete();

        \DB::table('menu_items')->insert([
            0 => [
                'id' => 1,
                'label' => 'Dashboard',
                'link' => 'dashboard',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\DashboardController@index","route_name":["dashboard"]}',
                'is_default' => 1,
                'icon' => 'fas fa-home',
                'parent' => 0,
                'sort' => 0,
                'class' => null,
                'menu' => 1,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            1 => [
                'id' => 2,
                'label' => 'Add User',
                'link' => 'user/create',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\UserController@create","route_name":["users.create"]}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 27,
                'sort' => 2,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            2 => [
                'id' => 3,
                'label' => 'Add Product',
                'link' => 'product/create',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\ProductController@createProduct","route_name":["product.create"]}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 28,
                'sort' => 7,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            3 => [
                'id' => 4,
                'label' => 'categories',
                'link' => 'categories',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\CategoryController@index","route_name":["categories.index"]}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 28,
                'sort' => 10,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            4 => [
                'id' => 5,
                'label' => 'Brands',
                'link' => 'brands',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\BrandController@index","route_name":["brands.index","brands.create","brands.edit","brands.pdf","brands.csv"]}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 28,
                'sort' => 11,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            5 => [
                'id' => 6,
                'label' => 'attributes',
                'link' => 'attributes',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\AttributeController@index","route_name":["attribute.index","attribute.create","attribute.edit","attribute.pdf","attribute.csv"]}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 28,
                'sort' => 12,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            6 => [
                'id' => 8,
                'label' => 'All Users',
                'link' => 'user/list',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\UserController@index","route_name":["users.index","users.edit","users.pdf","users.csv","users.verify"]}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 27,
                'sort' => 3,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            7 => [
                'id' => 9,
                'label' => 'Reviews',
                'link' => 'reviews',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\ReviewController@index","route_name":["review.index","review.view","review.edit","review.pdf","review.csv"]}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 28,
                'sort' => 13,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            8 => [
                'id' => 10,
                'label' => 'All Products',
                'link' => 'products',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\ProductController@index","route_name":["product.index","product.edit","product.pdf","product.csv"]}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 28,
                'sort' => 8,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            9 => [
                'id' => 11,
                'label' => 'Pending Products',
                'link' => 'pending/products?status=Pending Review',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\ProductController@index","route_name":["product.pending"]}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 28,
                'sort' => 9,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            10 => [
                'id' => 12,
                'label' => 'Add vendor',
                'link' => 'vendors/create',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\VendorController@create","route_name":["vendors.create"]}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 30,
                'sort' => 19,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            11 => [
                'id' => 13,
                'label' => 'All vendors',
                'link' => 'vendors',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\Api\\\\VendorController@index","route_name":["vendors.index","vendors.edit","vendors.pdf","vendors.csv","vendors.import"]}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 30,
                'sort' => 20,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            12 => [
                'id' => 14,
                'label' => 'Addon Manager',
                'link' => 'addons',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\AddonsMangerController@index","route_name":["addon.index","addon.switch-status","addon.remove","addon.upload"]}',
                'is_default' => 1,
                'icon' => 'fas fa-plug',
                'parent' => 0,
                'sort' => 58,
                'class' => null,
                'menu' => 1,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            13 => [
                'id' => 16,
                'label' => 'Menus',
                'link' => 'menu-builder',
                'params' => '{"permission":"Modules\\\\MenuBuilder\\\\Http\\\\Controllers\\\\MenuBuilderController@index","route_name":["menu.index"]}',
                'is_default' => 1,
                'icon' => 'fas fa-bars',
                'parent' => 0,
                'sort' => 33,
                'class' => null,
                'menu' => 1,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            14 => [
                'id' => 19,
                'label' => 'General Settings',
                'link' => 'general-setting',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\CompanySettingController@index","route_name":["preferences.index", "companyDetails.setting", "maintenance.enable", "language.translation", "language.index", "currency.convert", "withdrawalSetting.index", "external-codes.index"]}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 31,
                'sort' => 49,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            15 => [
                'id' => 20,
                'label' => 'Products',
                'link' => 'product-setting',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\ProductSettingController@general","route_name":["product.setting.general","product.setting.inventory", "product.setting.vendor"]}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 31,
                'sort' => 51,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            16 => [
                'id' => 21,
                'label' => 'Customers',
                'link' => 'user/customer?role=3',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\UserController@index","route_name":["users.customer"]}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 27,
                'sort' => 4,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            18 => [
                'id' => 27,
                'label' => 'Personnel',
                'link' => null,
                'params' => null,
                'is_default' => 0,
                'icon' => 'fas fa-users',
                'parent' => 0,
                'sort' => 1,
                'class' => null,
                'menu' => 1,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            19 => [
                'id' => 28,
                'label' => 'Products',
                'link' => 'Items main',
                'params' => null,
                'is_default' => 0,
                'icon' => 'fas fa-cube',
                'parent' => 0,
                'sort' => 6,
                'class' => null,
                'menu' => 1,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            20 => [
                'id' => 30,
                'label' => 'Vendors',
                'link' => null,
                'params' => null,
                'is_default' => 0,
                'icon' => 'fas fa-user-plus',
                'parent' => 0,
                'sort' => 18,
                'class' => null,
                'menu' => 1,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            21 => [
                'id' => 31,
                'label' => 'Configurations',
                'link' => null,
                'params' => null,
                'is_default' => 0,
                'icon' => 'fas fa-cog',
                'parent' => 0,
                'sort' => 48,
                'class' => null,
                'menu' => 1,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            22 => [
                'id' => 32,
                'label' => 'Dashboard',
                'link' => 'dashboard',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\Site\\\\DashboardController@index","route_name":["site.dashboard"],"menu_level":"2"}',
                'is_default' => 1,
                'icon' => 'fas fa-align-justify',
                'parent' => 0,
                'sort' => 0,
                'class' => null,
                'menu' => 2,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            23 => [
                'id' => 33,
                'label' => 'Orders',
                'link' => 'orders',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\Site\\\\OrderController@index","route_name":["site.order", "site.orderDetails", "site.orderRefund"],"menu_level":"2"}',
                'is_default' => 1,
                'icon' => 'fab fa-apple',
                'parent' => 0,
                'sort' => 1,
                'class' => null,
                'menu' => 2,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            24 => [
                'id' => 34,
                'label' => 'Wishlist',
                'link' => 'wishlists',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\Site\\\\WishlistController@index","route_name":["site.wishlist"],"menu_level":"2"}',
                'is_default' => 1,
                'icon' => 'far fa-heart',
                'parent' => 0,
                'sort' => 2,
                'class' => null,
                'menu' => 2,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            25 => [
                'id' => 35,
                'label' => 'Reviews',
                'link' => 'reviews',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\Site\\\\ReviewController@index","route_name":["site.review"],"menu_level":"2"}',
                'is_default' => 1,
                'icon' => 'fas fa-certificate',
                'parent' => 0,
                'sort' => 3,
                'class' => null,
                'menu' => 2,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            26 => [
                'id' => 36,
                'label' => 'My Profile',
                'link' => 'profile',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\UserController@index","route_name":["site.userProfile","site.userProfileEditPassword"],"menu_level":"2"}',
                'is_default' => 1,
                'icon' => 'fas fa-user',
                'parent' => 0,
                'sort' => 4,
                'class' => null,
                'menu' => 2,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            27 => [
                'id' => 37,
                'label' => 'Address Books',
                'link' => 'addresses',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\Site\\\\AddressController@index","route_name":["site.address","site.addressCreate","site.addressEdit"],"menu_level":"2"}',
                'is_default' => 1,
                'icon' => 'fas fa-phone',
                'parent' => 0,
                'sort' => 5,
                'class' => null,
                'menu' => 2,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            28 => [
                'id' => 38,
                'label' => 'Settings',
                'link' => 'setting',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\Site\\\\AddressController@index","route_name":["site.userSetting"],"menu_level":"2"}',
                'is_default' => 1,
                'icon' => 'fas fa-cog',
                'parent' => 0,
                'sort' => 8,
                'class' => null,
                'menu' => 2,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            29 => [
                'id' => 39,
                'label' => 'Logout',
                'link' => 'logout',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\Site\\\\LoginController@logout", "route_name":["site.logout"], "menu_level":"2"}',
                'is_default' => 1,
                'icon' => 'fas fa-sign-out-alt',
                'parent' => 0,
                'sort' => 10,
                'class' => null,
                'menu' => 2,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            30 => [
                'id' => 40,
                'label' => 'Dashboard',
                'link' => 'dashboard',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\VendorController@index","route_name":["vendor-dashboard"],"menu_level":"3"}',
                'is_default' => 1,
                'icon' => 'fas fa-home',
                'parent' => 0,
                'sort' => 0,
                'class' => null,
                'menu' => 3,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            31 => [
                'id' => 42,
                'label' => 'All Orders',
                'link' => 'orders',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\AdminOrderController@index", "route_name":["order.index", "order.view", "order.pdf", "order.csv"], "menu_level":"1"}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 43,
                'sort' => 15,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            32 => [
                'id' => 43,
                'label' => 'Orders',
                'link' => null,
                'params' => null,
                'is_default' => 0,
                'icon' => 'fas fa-shopping-bag',
                'parent' => 0,
                'sort' => 14,
                'class' => null,
                'menu' => 1,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            33 => [
                'id' => 44,
                'label' => 'shipping',
                'link' => 'shippings',
                'params' => '{"permission":"Modules\\\\Shipping\\\\Http\\\\Controllers\\\\ShippingController@index","route_name":["shipping.index"]}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 31,
                'sort' => 52,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            34 => [
                'id' => 47,
                'label' => 'Orders',
                'link' => 'orders',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\Vendor\\\\VendorOrderController@index", "route_name":["vendorOrder.index", "vendorOrder.view", "vendorOrder.pdf", "vendorOrder.csv"], "menu_level":"3"}',
                'is_default' => 1,
                'icon' => 'fas fa-shopping-bag',
                'parent' => 0,
                'sort' => 2,
                'class' => null,
                'menu' => 3,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            35 => [
                'id' => 48,
                'label' => 'Transactions',
                'link' => 'transactions',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\TransactionController@index", "route_name":["transaction.index", "transaction.edit"], "menu_level":"1"}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 43,
                'sort' => 16,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            36 => [
                'id' => 49,
                'label' => 'Geo Locale',
                'link' => 'geolocale',
                'params' => '{"permission":"Modules\\\\GeoLocale\\\\Http\\\\Controllers\\\\GeoLocaleController@index", "route_name":["geolocale.index"], "menu_lavel":"1"}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 31,
                'sort' => 58,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            37 => [
                'id' => 51,
                'label' => 'Refunds',
                'link' => 'refund-requests',
                'params' => '{"permission":"Modules\\\\Refund\\\\Http\\\\Controllers\\\\RefundController@index","route_name":["refund.index"], "menu_level":"1"}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 43,
                'sort' => 17,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            38 => [
                'id' => 52,
                'label' => 'Refunds',
                'link' => 'refund-requests',
                'params' => '{"permission":"Modules\\\\Refund\\\\Http\\\\Controllers\\\\Vendor\\\\RefundController@index","route_name":["vendor.refund.index"], "menu_level":"3"}',
                'is_default' => 1,
                'icon' => 'fas fa-retweet',
                'parent' => 0,
                'sort' => 6,
                'class' => null,
                'menu' => 3,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            39 => [
                'id' => 53,
                'label' => 'Refunds',
                'link' => 'refund-request',
                'params' => '{"permission":"Modules\\\\Refund\\\\Http\\\\Controllers\\\\Site\\\\RefundController@index","route_name":["site.refundRequest", "site.createRefundRequest", "site.refundDetails"], "menu_level":"2"}',
                'is_default' => 1,
                'icon' => 'fas fa-backward',
                'parent' => 0,
                'sort' => 5,
                'class' => null,
                'menu' => 2,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            40 => [
                'id' => 54,
                'label' => 'Categories',
                'link' => 'blog/category/list',
                'params' => '{"permission":"Modules\\\\Blog\\\\Http\\\\Controllers\\\\BlogCategoryController@index", "route_name":["blog.category.index"], "menu_level":"1"}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 56,
                'sort' => 25,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            41 => [
                'id' => 55,
                'label' => 'Add Post',
                'link' => 'blog/create',
                'params' => '{"permission":"Modules\\\\Blog\\\\Http\\\\Controllers\\\\BlogController@create", "route_name":["blog.create"], "menu_level":"1"}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 56,
                'sort' => 23,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            42 => [
                'id' => 56,
                'label' => 'Blogs',
                'link' => null,
                'params' => null,
                'is_default' => 1,
                'icon' => 'fab fa-blogger-b',
                'parent' => 0,
                'sort' => 22,
                'class' => null,
                'menu' => 1,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            43 => [
                'id' => 57,
                'label' => 'Website Setup',
                'link' => null,
                'params' => null,
                'is_default' => 1,
                'icon' => 'fas fa-globe',
                'parent' => 0,
                'sort' => 38,
                'class' => null,
                'menu' => 1,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            44 => [
                'id' => 58,
                'label' => 'All Sliders',
                'link' => 'sliders',
                'params' => '{"permission":"Modules\\\\CMS\\\\Http\\\\Controllers\\\\SliderController@index", "route_name":["slider.index", "slide.create", "slide.edit"], "menu_level":"1"}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 57,
                'sort' => 39,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            45 => [
                'id' => 59,
                'label' => 'All Posts',
                'link' => 'blogs',
                'params' => '{"permission":"Modules\\\\Blog\\\\Http\\\\Controllers\\\\BlogController@index", "route_name":["blog.index", "blog.edit"], "menu_level":"1"}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 56,
                'sort' => 24,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            46 => [
                'id' => 60,
                'label' => 'Pages',
                'link' => 'page/list',
                'params' => '{"permission":"Modules\\\\CMS\\\\Http\\\\Controllers\\\\CMSController@index", "route_name":["page.index", "page.create", "page.edit"], "menu_level":"1"}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 57,
                'sort' => 41,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            47 => [
                'id' => 61,
                'label' => 'Media Manager',
                'link' => 'uploaded-files',
                'params' => '{"permission":"Modules\\\\MediaManager\\\\Http\\\\Controllers\\\\MediaManagerController@uploadedFiles", "route_name":["mediaManager.create", "mediaManager.upload", "mediaManager.uploadedFiles", "mediaManager.sortFiles", "mediaManager.paginateFiles", "mediaManager.download", "mediaManager.maxId"], "menu_level":"1"}',
                'is_default' => 1,
                'icon' => 'fas fa-folder-open',
                'parent' => 0,
                'sort' => 43,
                'class' => null,
                'menu' => 1,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            48 => [
                'id' => 63,
                'label' => 'Reports',
                'link' => 'reports',
                'params' => '{"permission":"Modules\\\\Report\\\\Http\\\\Controllers\\\\ReportController@index", "route_name":["reports"], "menu_level":"1"}',
                'is_default' => 1,
                'icon' => 'fas fa-chart-bar',
                'parent' => 0,
                'sort' => 57,
                'class' => null,
                'menu' => 1,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            49 => [
                'id' => 64,
                'label' => 'All popups',
                'link' => 'popups',
                'params' => '{"permission":"Modules\\\\Popup\\\\Http\\\\Controllers\\\\PopupController@index", "route_name":["popup.index", "popup.show", "popup.store", "popup.edit", "popup.update", "popup.delete"], "menu_level":"1"}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 73,
                'sort' => 31,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            50 => [
                'id' => 65,
                'label' => 'Withdrawals',
                'link' => 'withdrawals',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\Vendor\\\\WithdrawalController@index","route_name":["vendorWithdrawal.index", "vendorWithdrawal.setting", "vendorWithdrawal.money"]}',
                'is_default' => 1,
                'icon' => 'far fa-credit-card',
                'parent' => 0,
                'sort' => 3,
                'class' => null,
                'menu' => 3,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            51 => [
                'id' => 66,
                'label' => 'Withdrawals',
                'link' => 'withdrawals',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\WithdrawalController@index", "route_name":["withdrawal.index", "withdrawal.edit"], "menu_level":"1"}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 30,
                'sort' => 21,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            52 => [
                'id' => 67,
                'label' => 'Forms',
                'link' => null,
                'params' => '{"permission":"Modules\\\\FormBuilder\\\\Http\\\\Controllers\\\\FormController@index","route_name":["formbuilder::kyc.index", "formbuilder::kyc.edit", "formbuilder::kyc.sub-view", "formbuilder::submissions.all","formbuilder::entry.index","formbuilder::entry.edit", "formbuilder::entry.update", "formbuilder::entry.show", "formbuilder::forms.index", "formbuilder::forms.create", "formbuilder::forms.edit"]}',
                'is_default' => 0,
                'icon' => 'fas fa-window-restore',
                'parent' => 0,
                'sort' => 34,
                'class' => null,
                'menu' => 1,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            53 => [
                'id' => 68,
                'label' => 'All Forms',
                'link' => 'forms',
                'params' => '{"permission":"Modules\\\\FormBuilder\\\\Http\\\\Controllers\\\\FormController@index", "route_name":["formbuilder::forms.index", "formbuilder::forms.create", "formbuilder::forms.edit"], "menu_level":"1"}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 67,
                'sort' => 35,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            54 => [
                'id' => 69,
                'label' => 'All Submissions',
                'link' => 'forms/submissions',
                'params' => '{"permission":"Modules\\\\FormBuilder\\\\Http\\\\Controllers\\\\SubmissionController@index", "route_name":["formbuilder::submissions.all","formbuilder::entry.index","formbuilder::entry.edit", "formbuilder::entry.update", "formbuilder::entry.show"], "menu_level":"1"}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 67,
                'sort' => 36,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            55 => [
                'id' => 70,
                'label' => 'KYC',
                'link' => 'forms/kyc-form',
                'params' => '{"permission":"Modules\\\\FormBuilder\\\\Http\\\\Controllers\\\\KycController@index", "route_name":["formbuilder::kyc.index", "formbuilder::kyc.edit", "formbuilder::kyc.sub-view", "formbuilder::kyc.sub-edit"], "menu_level":"1"}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 67,
                'sort' => 37,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            56 => [
                'id' => 71,
                'label' => 'KYC',
                'link' => 'kyc',
                'params' => '{"permission":"Modules\\\\FormBuilder\\\\Http\\\\Controllers\\\\Vendor\\\\KycController@userKycForm", "route_name":["kyc.user.show"], "menu_level":"3"}',
                'is_default' => 1,
                'icon' => 'far fa-address-card',
                'parent' => 0,
                'sort' => 9,
                'class' => null,
                'menu' => 3,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            57 => [
                'id' => 72,
                'label' => 'Add coupon',
                'link' => 'coupon/create',
                'params' => '{"permission":"Modules\\\\Coupon\\\\Http\\\\Controllers\\\\CouponController@create","route_name":["coupon.create"]}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 73,
                'sort' => 27,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            58 => [
                'id' => 73,
                'label' => 'Marketing',
                'link' => null,
                'params' => null,
                'is_default' => 0,
                'icon' => 'fas fa-bullhorn',
                'parent' => 0,
                'sort' => 26,
                'class' => null,
                'menu' => 1,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            59 => [
                'id' => 75,
                'label' => 'Coupons',
                'link' => 'coupons',
                'params' => '{"permission":"Modules\\\\Coupon\\\\Http\\\\Controllers\\\\Vendor\\\\CouponController@index","route_name":["vendor.coupons", "vendor.couponCreate", "vendor.couponEdit", "vendor.couponProduct"]}',
                'is_default' => 1,
                'icon' => 'fas fa-percent',
                'parent' => 0,
                'sort' => 4,
                'class' => null,
                'menu' => 3,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            60 => [
                'id' => 76,
                'label' => 'Products',
                'link' => 'products',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\Vendor\\\\ProductController@index","route_name":["vendor.products","vendor.product.view","vendor.product.related","vendor.product.search","vendor.product.update","vendor.product.edit", "vendor.product.store", "vendor.product.create", "vendor.product.import", "vendor.itemCsv", "vendor.itemPdf", "vendor.itemDestroy", "vendor.items"]}',
                'is_default' => 1,
                'icon' => 'fas fa-cube',
                'parent' => 0,
                'sort' => 1,
                'class' => null,
                'menu' => 3,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            61 => [
                'id' => 77,
                'label' => 'Reviews',
                'link' => 'reviews',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\ReviewController@index","route_name":["vendor.reviewCsv","vendor.reviewPdf","vendor.reviewDestroy","vendor.reviewUpdate","vendor.reviewView", "vendor.reviewEdit", "vendor.reviews"]}',
                'is_default' => 1,
                'icon' => 'fas fa-star',
                'parent' => 0,
                'sort' => 8,
                'class' => null,
                'menu' => 3,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            62 => [
                'id' => 81,
                'label' => 'Add Popup',
                'link' => 'popup/create',
                'params' => '{"permission":"Modules\\\\Popup\\\\Http\\\\Controllers\\\\PopupController@create", "route_name":["popup.create"], "menu_level":"1"}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 73,
                'sort' => 30,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            63 => [
                'id' => 83,
                'label' => 'Transactions',
                'link' => 'transactions',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\Vendor\\\\VendorTransactionController@index", "route_name":["vendorTransaction.index", "vendorTransaction.pdf", "vendorTransaction.csv"], "menu_lavel":"3"}',
                'is_default' => 1,
                'icon' => 'fas fa-exchange-alt',
                'parent' => 0,
                'sort' => 5,
                'class' => null,
                'menu' => 3,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            64 => [
                'id' => 84,
                'label' => 'All Subscribers',
                'link' => 'subscribers',
                'params' => '{"permission":"Modules\\\\Newsletter\\\\Http\\\\Controllers\\\\SubscriberController@index","route_name":["subscriber.index","subscriber.edit","subscriber.update","subscriber.pdf","subscriber.csv"]}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 73,
                'sort' => 32,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            65 => [
                'id' => 87,
                'label' => 'Taxes',
                'link' => 'taxes',
                'params' => '{"permission":"Modules\\\\Tax\\\\Http\\\\Controllers\\\\TaxClassController@index","route_name":["tax.index"]}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 31,
                'sort' => 53,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            66 => [
                'id' => 88,
                'label' => 'Be a seller',
                'link' => 'seller/request-form',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\Site\\\\RegisteredSellerController@showRequestForm", "route_name":["site.seller.request-form"], "menu_lavel":"2"}',
                'is_default' => 1,
                'icon' => 'fas fa-universal-access',
                'parent' => 0,
                'sort' => 7,
                'class' => null,
                'menu' => 2,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            67 => [
                'id' => 90,
                'label' => 'Support Tickets',
                'link' => null,
                'params' => null,
                'is_default' => 1,
                'icon' => 'fas fa-ticket-alt',
                'parent' => 0,
                'sort' => 44,
                'class' => null,
                'menu' => 1,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            68 => [
                'id' => 92,
                'label' => 'Appearance',
                'link' => 'theme/list',
                'params' => '{"permission":"Modules\\\\CMS\\\\Http\\\\Controllers\\\\ThemeOptionController@list", "route_name":["theme.index", "theme.store"], "menu_level":"1"}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 57,
                'sort' => 42,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            69 => [
                'id' => 93,
                'label' => 'Home Pages',
                'link' => 'page/home/list',
                'params' => '{"permission":"Modules\\\\CMS\\\\Http\\\\Controllers\\\\CMSController@index", "route_name":["page.home", "builder.edit", "page.home.create", "page.home.edit"], "menu_level":"1"}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 57,
                'sort' => 40,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            70 => [
                'id' => 99,
                'label' => 'Orders',
                'link' => 'order-setting',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\ProductSettingController@general","route_name":["order.setting.option", "orderStatues.index"]}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 31,
                'sort' => 51,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            71 => [
                'id' => 100,
                'label' => 'Accounts',
                'link' => 'account-setting',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\AccountSettingController@index","route_name":["account.setting.option", "sso.index", "emailVerifySetting", "preferences.password", "permissionRoles.index", "roles.index", "roles.create", "roles.edit"]}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 31,
                'sort' => 54,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            72 => [
                'id' => 101,
                'label' => 'Emails',
                'link' => 'email-setting',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\EmailConfigurationController@index","route_name":["emailConfigurations.index", "emailTemplates.index", "emailTemplates.create", "emailTemplates.edit"]}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 31,
                'sort' => 55,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            73 => [
                'id' => 102,
                'label' => 'Reports',
                'link' => 'reports',
                'params' => '{"permission":"Modules\\\\Report\\\\Http\\\\Controllers\\\\Vendor\\\\ReportController@index", "route_name":["vendor.reports"], "menu_level":"3"}',
                'is_default' => 1,
                'icon' => 'fas fa-chart-bar',
                'parent' => 0,
                'sort' => 10,
                'class' => null,
                'menu' => 3,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            74 => [
                'id' => 103,
                'label' => 'Add Ticket',
                'link' => 'ticket/add',
                'params' => '{"permission":"Modules\\\\Ticket\\\\Http\\\\Controllers\\\\TicketController@add", "route_name":["admin.threadAdd"]}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 90,
                'sort' => 45,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            75 => [
                'id' => 104,
                'label' => 'All Tickets',
                'link' => 'ticket/list',
                'params' => '{"permission":"Modules\\\\Ticket\\\\Http\\\\Controllers\\\\TicketController@index", "route_name":["admin.tickets", "admin.threadReply", "admin.threadEdit", "admin.threadPdf", "admin.changePriority"]}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 90,
                'sort' => 46,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            76 => [
                'id' => 105,
                'label' => 'All Coupons',
                'link' => 'coupons',
                'params' => '{"permission":"Modules\\\\Coupon\\\\Http\\\\Controllers\\\\CouponController@index","route_name":["coupon.index","coupon.edit","coupon.pdf","coupon.csv","coupon.shop","coupon.item"]}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 73,
                'sort' => 28,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            77 => [
                'id' => 106,
                'label' => 'Coupon Redeems',
                'link' => 'coupon-redeems',
                'params' => '{"permission":"Modules\\\\Coupon\\\\Http\\\\Controllers\\\\CouponRedeemController@index","route_name":["couponRedeem.index"]}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 73,
                'sort' => 29,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            78 => [
                'id' => 111,
                'label' => 'Download',
                'link' => 'downloads',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\Site\\\\DownloadController@index","route_name":["site.download"],"menu_level":"2"}',
                'is_default' => 1,
                'icon' => 'fa fa-download',
                'parent' => 0,
                'sort' => 9,
                'class' => null,
                'menu' => 2,
                'depth' => 0,
                'is_custom_menu' => 1,
            ],
            79 => [
                'id' => 112,
                'label' => 'Login Activities',
                'link' => 'user/activity',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\UserController@index","route_name":["users.activity"]}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 27,
                'sort' => 5,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            85 => [
                'id' => 119,
                'label' => 'Shop',
                'link' => 'search-products?categories=&keyword=&brands=&attributes=&price_range=&rating=&sort_by=Price%20Low%20to%20High',
                'params' => '{"permission":"no-prefix"}',
                'is_default' => 0,
                'icon' => null,
                'parent' => 0,
                'sort' => 10,
                'class' => null,
                'menu' => 4,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            86 => [
                'id' => 120,
                'label' => 'Coupon',
                'link' => 'coupon',
                'params' => '{"permission":"no-prefix"}',
                'is_default' => 0,
                'icon' => null,
                'parent' => 0,
                'sort' => 11,
                'class' => null,
                'menu' => 4,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            87 => [
                'id' => 121,
                'label' => 'Blogs',
                'link' => 'blogs',
                'params' => '{"permission":"no-prefix"}',
                'is_default' => 0,
                'icon' => null,
                'parent' => 0,
                'sort' => 12,
                'class' => null,
                'menu' => 4,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            88 => [
                'id' => 122,
                'label' => 'Pages',
                'link' => '#pages',
                'params' => '{"permission":"no-prefix"}',
                'is_default' => 0,
                'icon' => null,
                'parent' => 0,
                'sort' => 13,
                'class' => null,
                'menu' => 4,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            89 => [
                'id' => 123,
                'label' => 'About Us',
                'link' => 'page/about-us',
                'params' => null,
                'is_default' => 0,
                'icon' => null,
                'parent' => 122,
                'sort' => 14,
                'class' => null,
                'menu' => 4,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            90 => [
                'id' => 124,
                'label' => 'Contact Us',
                'link' => 'page/contact-us',
                'params' => null,
                'is_default' => 0,
                'icon' => null,
                'parent' => 122,
                'sort' => 15,
                'class' => null,
                'menu' => 4,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            96 => [
                'id' => 130,
                'label' => 'Tickets',
                'link' => 'ticket/list',
                'params' => '{"permission":"Modules\\\\Ticket\\\\Http\\\\Controllers\\\\Vendor\\\\TicketController@index", "route_name":["vendor.threadAdd", "vendor.threadReply", "vendor.threads"], "menu_level":"3"}',
                'is_default' => 1,
                'icon' => 'fas fa-ticket-alt',
                'parent' => 0,
                'sort' => 11,
                'class' => null,
                'menu' => 3,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            97 => [
                'id' => 131,
                'label' => 'Import Products',
                'link' => 'import/products',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\Vendor\\\\ImportController@productImport", "route_name":["vendor.epz.import.products"], "menu_level":"3"}',
                'is_default' => 1,
                'icon' => 'fas fa-download',
                'parent' => 0,
                'sort' => 7,
                'class' => null,
                'menu' => 3,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            98 => [
                'id' => 132,
                'label' => 'Tools',
                'link' => null,
                'params' => null,
                'is_default' => 1,
                'icon' => 'fas fa-cogs',
                'parent' => 0,
                'sort' => 47,
                'class' => null,
                'menu' => 1,
                'depth' => 0,
                'is_custom_menu' => 0,
            ],
            99 => [
                'id' => 133,
                'label' => 'System Info',
                'link' => 'system-info',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\SystemInfoController@index", "route_name":["systemInfo.index"], "menu_level":"2"}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 31,
                'sort' => 59,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            100 => [
                'id' => 134,
                'label' => 'Export Products',
                'link' => 'export/products',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\Vendor\\\\ExportController@productExport", "route_name":["vendor.epz.export.products"], "menu_level":"3"}',
                'is_default' => 1,
                'icon' => 'fas fa-download',
                'parent' => 0,
                'sort' => 6,
                'class' => null,
                'menu' => 3,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            101 => [
                'id' => 135,
                'label' => 'Import',
                'link' => 'imports',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\ImportController@index", "route_name":["epz.import.products", "epz.imports", "epz.import.users", "import.dummy"]}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 132,
                'sort' => 48,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            102 => [
                'id' => 136,
                'label' => 'Export',
                'link' => 'exports',
                'params' => '{"permission":"App\\\\Http\\\\Controllers\\\\ExportController@index", "route_name":["epz.export.products", "epz.exports"]}',
                'is_default' => 1,
                'icon' => null,
                'parent' => 132,
                'sort' => 49,
                'class' => null,
                'menu' => 1,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
            109 => [
                'id' => 143,
                'label' => 'All Categories',
                'link' => 'categories',
                'params' => null,
                'is_default' => 0,
                'icon' => null,
                'parent' => 122,
                'sort' => 16,
                'class' => null,
                'menu' => 4,
                'depth' => 1,
                'is_custom_menu' => 0,
            ],
        ]);

    }
}
