<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVendorCategoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('vendor_categories', function (Blueprint $table) {
            $table->bigInteger('id', true);
            $table->integer('category_id')->index('vendor_categories_category_id_foreign_idx');
            $table->bigInteger('vendor_id')->index('vendor_categories_vendor_id_foreign_idx');
            $table->bigInteger('shop_id')->nullable()->index('vendor_categories_shop_id_foreign_idx');
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vendor_categories');
    }
}
