
<?php $__env->startSection('page_title', __('Password Preferences')); ?>
<?php $__env->startSection('css'); ?>
    <!-- daterange picker -->
    <link rel="stylesheet" href="<?php echo e(asset('public/dist/plugins/bootstrap-daterangepicker/daterangepicker.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Main content -->
    <div class="col-sm-12" id="password-preference-settings-container">
        <div class="card">
            <div class="card-body row">
                <div
                    class="col-lg-3 col-12 z-index-10 ltr:ps-md-3 ltr:pe-0 ltr:ps-0 rtl:pe-md-3 rtl:ps-0 rtl:pe-0">
                    <?php echo $__env->make('admin.layouts.includes.account_settings_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="col-lg-9 col-12 ltr:ps-0 rtl:pe-0">
                    <div class="card card-info shadow-none mb-0">
                        <div class="card-header p-t-20 border-bottom">
                            <h5><?php echo e(__('Password Preferences')); ?></h5>
                        </div>
                        <div class="card-block table-border-style">
                            <form action="<?php echo e(route('preferences.password')); ?>" method="post" class="form-horizontal"
                                id="preference_form">
                                <?php echo csrf_field(); ?>

                                <?php
                                    $uppercase = $lowercase = $number = $symbol = $length = false;
                                    if (env('PASSWORD_STRENGTH') != null && env('PASSWORD_STRENGTH') != '') {
                                        $length = filter_var(env('PASSWORD_STRENGTH'), FILTER_SANITIZE_NUMBER_INT);
                                        $conditions = explode('|', env('PASSWORD_STRENGTH'));
                                        $uppercase = in_array('UPPERCASE', $conditions);
                                        $lowercase = in_array('LOWERCASE', $conditions);
                                        $number = in_array('NUMBERS', $conditions);
                                        $symbol = in_array('SYMBOLS', $conditions);
                                    }

                                ?>
                                <div class="card-body p-0">

                                    <div class="form-group row">
                                        <label class="col-sm-3 control-label text-left"
                                            for="length"><?php echo e(__('Minimum Password Length')); ?></label>
                                        <div class="col-sm-6">
                                            <input type="number" name="length" id="length"
                                                class="form-control inputFieldDesign" value="<?php echo e($length ? $length : 4); ?>"
                                                max="32" min="4"
                                                data-min="<?php echo e(__('This value must be greater than :x.', ['x' => '3'])); ?>"
                                                data-max="<?php echo e(__('The value must be :x than or equal to :y.', ['x' => __('less'), 'y' => 32])); ?>">
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-3 control-label text-left"
                                            for="uppercase"><?php echo e(__('Include Uppercase')); ?></label>
                                        <div class="col-6">
                                            <div class="switch switch-bg d-inline m-r-10 edit-is_default">
                                                <input class="uppercase" type="checkbox" value="1" name="uppercase"
                                                    id="uppercase" <?php echo e($uppercase ? 'checked' : ''); ?>>
                                                <label for="uppercase" class="cr"></label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-3 control-label text-left"
                                            for="lowercase"><?php echo e(__('Include Lowercase')); ?></label>
                                        <div class="col-6">
                                            <div class="switch switch-bg d-inline m-r-10 edit-is_default">
                                                <input class="lowercase" type="checkbox" value="1" name="lowercase"
                                                    id="lowercase" <?php echo e($lowercase ? 'checked' : ''); ?>>
                                                <label for="lowercase" class="cr"></label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-3 control-label text-left"
                                            for="number"><?php echo e(__('Include Numbers')); ?></label>
                                        <div class="col-6">
                                            <div class="switch switch-bg d-inline m-r-10 edit-is_default">
                                                <input class="number" type="checkbox" value="1" name="number"
                                                    id="number" <?php echo e($number ? 'checked' : ''); ?>>
                                                <label for="number" class="cr"></label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-3 control-label text-left"
                                            for="symbol"><?php echo e(__('Include Symbols')); ?></label>
                                        <div class="col-6">
                                            <div class="switch switch-bg d-inline m-r-10 edit-is_default">
                                                <input class="symbol" type="checkbox" value="1" name="symbol"
                                                    id="symbol" <?php echo e($symbol ? 'checked' : ''); ?>>
                                                <label for="symbol" class="cr"></label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="card-footer p-0">
                                        <div class="form-group row">
                                            <label for="btn_save" class="col-sm-3 control-label"></label>
                                            <div class="col-sm-12">
                                                <button type="submit" class="btn form-submit custom-btn-submit ltr:float-right rtl:float-left"
                                                    id="footer-btn">
                                                    <?php echo e(__('Save')); ?>

                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('public/dist/js/custom/preference.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/js/custom/validation.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/creativedesignbd/ecommerce9.creativedesign.com.bd/resources/views/admin/preference/password.blade.php ENDPATH**/ ?>