
<?php $__env->startSection('page_title', __('Product Setting')); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('Modules/CMS/Resources/assets/css/style.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/dist/css/product.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="col-sm-12">
        <div class="card admin-panel-product-setting" id="theme-container">
            <div class="card-body row">
                <div class="col-lg-3 col-12 z-index-10  ltr:ps-md-3 ltr:pe-0 ltr:ps-0 rtl:pe-md-3 rtl:ps-0 rtl:pe-0"
                    aria-labelledby="navbarDropdown">
                    <div class="card card-info shadow-none">
                        <div class="card-header p-t-20 border-bottom mb-2">
                            <h5><?php echo e(__('Product Setting')); ?></h5>
                        </div>
                        <ul class="nav flex-column nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                            <li><a class="nav-link active text-left tab-name" id="v-pills-general-tab" data-bs-toggle="pill"
                                    href="#v-pills-general" role="tab" aria-controls="v-pills-general"
                                    aria-selected="true" data-id=<?php echo e(__('Options')); ?>><?php echo e(__('Options')); ?></a></li>
                            <li><a class="nav-link text-left tab-name" id="v-pills-inventory-tab" data-bs-toggle="pill"
                                    href="#v-pills-inventory" role="tab" aria-controls="v-pills-inventory"
                                    aria-selected="true" data-id=<?php echo e(__('Inventory')); ?>><?php echo e(__('Inventory')); ?></a></li>
                            <li><a class="nav-link text-left tab-name" id="v-pills-vendor-tab" data-bs-toggle="pill"
                                    href="#v-pills-vendor" role="tab" aria-controls="v-pills-vendor"
                                    aria-selected="true" data-id=<?php echo e(__('Vendor')); ?>><?php echo e(__('Vendor')); ?></a></li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-9 col-12 ltr:ps-0 rtl:pe-0">
                    <div class="card card-info shadow-none mb-0">
                        <div class="card-header p-t-20 border-bottom">
                            <h5 id="theme-title"><?php echo e(__('Options')); ?></h5>
                        </div>

                        <div class="tab-content" id="topNav-v-pills-tabContent">
                            
                            <div class="tab-pane fade parent show active" id="v-pills-general" role="tabpanel"
                                aria-labelledby="v-pills-general-tab">
                                <div class="noti-alert pad no-print warningMessage mt-2">
                                    <div class="alert warning-message abc">
                                        <strong id="warning-msg" class="msg"></strong>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <form action="<?php echo e(route('product.setting.general')); ?>" method="post"
                                            class="form-horizontal product_setting_form">
                                            <?php echo csrf_field(); ?>
                                            <div class="card-body border-bottom table-border-style p-0">
                                                <div class="form-tabs">
                                                    <div class="tab-content box-shadow-unset px-0 py-2">
                                                        <div class="tab-pane fade show active" id="home"
                                                            role="tabpanel" aria-labelledby="home-tab">
                                                            <div class="form-group row mt-14">
                                                                <label class="col-3 control-label"><?php echo e(__('Product Type')); ?></label>
                                                                <div class="col-7">
                                                                    <div
                                                                        class="checkbox checkbox-warning checkbox-fill d-block">
                                                                        <input type="hidden" name="simple_product"
                                                                            value="0">
                                                                        <input type="checkbox" name="simple_product"
                                                                            id="simple_product" value="1"
                                                                            <?php echo e(preference('simple_product', '') == 1 ? 'checked' : ''); ?>>
                                                                        <label class="cr"
                                                                            for="simple_product"><?php echo e(__('Simple product.')); ?></label>
                                                                    </div>
                                                                    <div
                                                                        class="checkbox checkbox-warning checkbox-fill d-block">
                                                                        <input type="hidden" name="grouped_product"
                                                                            value="0">
                                                                        <input type="checkbox" name="grouped_product"
                                                                            id="grouped_product" value="1"
                                                                            <?php echo e(preference('grouped_product', '') == 1 ? 'checked' : ''); ?>>
                                                                        <label class="cr"
                                                                            for="grouped_product"><?php echo e(__('Grouped product.')); ?></label>
                                                                    </div>
                                                                    <div
                                                                        class="checkbox checkbox-warning checkbox-warning checkbox-fill d-block">
                                                                        <input type="hidden" name="affiliate_product"
                                                                            value="0">
                                                                        <input type="checkbox" name="affiliate_product"
                                                                            id="affiliate" value="1"
                                                                            <?php echo e(preference('affiliate_product', '') == 1 ? 'checked' : ''); ?>>
                                                                        <label class="cr"
                                                                            for="affiliate"><?php echo e(__('External/Affilate product.')); ?></label>
                                                                    </div>
                                                                    <div
                                                                        class="checkbox checkbox-warning checkbox-fill d-block">
                                                                        <input type="hidden" name="variable_product"
                                                                            value="0">
                                                                        <input type="checkbox" name="variable_product"
                                                                            id="variable_product" value="1"
                                                                            <?php echo e(preference('variable_product', '') == 1 ? 'checked' : ''); ?>>
                                                                        <label class="cr"
                                                                            for="variable_product"><?php echo e(__('Variable product.')); ?></label>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="form-group row">
                                                                <label for="taxes"
                                                                    class="col-3 control-label"><?php echo e(__('Taxes')); ?></label>
                                                                <div class="col-9 d-flex">
                                                                    <div class="ltr:me-3 rtl:ms-3">
                                                                        <input type="hidden" name="taxes"
                                                                            value="0">
                                                                        <div class="switch switch-bg d-inline m-r-10">
                                                                            <input type="checkbox" name="taxes"
                                                                                id="taxes" value="1"
                                                                                <?php echo e(preference('taxes', '') == 1 ? 'checked' : ''); ?>>
                                                                            <label for="taxes" class="cr"></label>
                                                                        </div>
                                                                    </div>
                                                                    <div class="mt-2">
                                                                        <span><?php echo e(__('Rates will be configurable and taxes will be calculated during checkout.')); ?></span>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="form-group row">
                                                                <label for="coupons"
                                                                    class="col-sm-3 control-label"><?php echo e(__('Coupons')); ?></label>
                                                                <div class="col-9 d-flex">
                                                                    <div class="ltr:me-3 rtl:ms-3">
                                                                        <input type="hidden" name="coupons"
                                                                            value="0">
                                                                        <div class="switch switch-bg d-inline m-r-10">
                                                                            <input type="checkbox" name="coupons"
                                                                                class="checkActivity" id="coupons"
                                                                                value="1"
                                                                                <?php echo e(preference('coupons', '') == 1 ? 'checked' : ''); ?>>
                                                                            <label for="coupons" class="cr"></label>
                                                                        </div>
                                                                    </div>
                                                                    <div class="mt-2">
                                                                        <span><?php echo e(__('Apply Coupon')); ?></span>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="form-group row dependency">
                                                                <label for="calculate_coupon"
                                                                    class="col-sm-3 control-label text-left"><?php echo e(__('Calculate coupon discounts sequentially')); ?></label>
                                                                <div class="col-9 d-flex">
                                                                    <div class="ltr:me-3 rtl:ms-3">
                                                                        <input type="hidden" name="calculate_coupon"
                                                                            value="0">
                                                                        <div class="switch switch-bg d-inline m-r-10">
                                                                            <input type="checkbox" name="calculate_coupon"
                                                                                id="calculate_coupon" value="1"
                                                                                <?php echo e(preference('calculate_coupon', '') == 1 ? 'checked' : ''); ?>>
                                                                            <label for="calculate_coupon"
                                                                                class="cr"></label>
                                                                        </div>
                                                                    </div>
                                                                    <div class="mt-2">
                                                                        <span><?php echo e(__('When applying multiple coupons, apply the first coupon to the full price and the second coupon to the discounted price, and so on.')); ?></span>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="form-group row">
                                                                <label for="calculate_coupon"
                                                                    class="col-sm-3 control-label text-left"><?php echo e(__('Measurements')); ?></label>
                                                                <div class="col-sm-4">
                                                                    <label for="measurement_weight"
                                                                        class="control-label"><?php echo e(__('Weight unit')); ?></label>
                                                                    <select class="form-control select2-hide-search"
                                                                        id="measurement_weight" name="measurement_weight">
                                                                        <option value="kg"
                                                                            <?php echo e(preference('measurement_weight', '') == 'kg' ? 'selected' : ''); ?>>
                                                                            kg</option>
                                                                        <option value="g"
                                                                            <?php echo e(preference('measurement_weight', '') == 'g' ? 'selected' : ''); ?>>
                                                                            g</option>
                                                                        <option value="lbs"
                                                                            <?php echo e(preference('measurement_weight', '') == 'lbs' ? 'selected' : ''); ?>>
                                                                            lbs</option>
                                                                    </select>
                                                                </div>

                                                                <div class="col-sm-4">
                                                                    <label for="measurement_dimension"
                                                                        class="control-label"><?php echo e(__('Dimension unit')); ?></label>
                                                                    <select class="form-control select2-hide-search"
                                                                        id="measurement_dimension"
                                                                        name="measurement_dimension">
                                                                        <option value="m"
                                                                            <?php echo e(preference('measurement_dimension', '') == 'm' ? 'selected' : ''); ?>>
                                                                            m</option>
                                                                        <option value="cm"
                                                                            <?php echo e(preference('measurement_dimension', '') == 'cm' ? 'selected' : ''); ?>>
                                                                            cm</option>
                                                                        <option value="mm"
                                                                            <?php echo e(preference('measurement_dimension', '') == 'mm' ? 'selected' : ''); ?>>
                                                                            mm</option>
                                                                        <option value="inch"
                                                                            <?php echo e(preference('measurement_dimension', '') == 'inch' ? 'selected' : ''); ?>>
                                                                            inch</option>
                                                                    </select>
                                                                </div>
                                                            </div>

                                                            <div class="form-group row mt-25">
                                                                <label for="review"
                                                                    class="col-sm-3 control-label text-left"><?php echo e(__('Reviews')); ?></label>
                                                                <div class="col-9 d-flex mt-neg-2">
                                                                    <div class="ltr:me-3 rtl:ms-3">
                                                                        <input type="hidden"
                                                                            name="reviews_enable_product_review"
                                                                            value="0">
                                                                        <div class="switch switch-bg d-inline m-r-10">
                                                                            <input type="checkbox"
                                                                                name="reviews_enable_product_review"
                                                                                class="checkActivity"
                                                                                id="reviews_enable_product_review"
                                                                                value="1"
                                                                                <?php echo e(preference('reviews_enable_product_review', '') == 1 ? 'checked' : ''); ?>>
                                                                            <label for="reviews_enable_product_review"
                                                                                class="cr"></label>
                                                                        </div>
                                                                    </div>
                                                                    <div class="mt-2">
                                                                        <span><?php echo e(__('Enable product reviews')); ?></span>
                                                                    </div>
                                                                </div>

                                                                <div class="col-9 offset-md-3 offset-1 dependency">
                                                                    <div class="d-flex">
                                                                        <div class="ltr:me-3 rtl:ms-3">
                                                                            <input type="hidden"
                                                                                name="reviews_verified_owner_label"
                                                                                value="0">
                                                                            <div class="switch switch-bg d-inline m-r-10">
                                                                                <input type="checkbox"
                                                                                    name="reviews_verified_owner_label"
                                                                                    id="reviews_verified_owner_label"
                                                                                    value="1"
                                                                                    <?php echo e(preference('reviews_verified_owner_label', '') == 1 ? 'checked' : ''); ?>>
                                                                                <label for="reviews_verified_owner_label"
                                                                                    class="cr"></label>
                                                                            </div>
                                                                        </div>
                                                                        <div class="mt-2">
                                                                            <span><?php echo e(__("Show 'verified owner' label on customer reviews")); ?></span>
                                                                        </div>
                                                                    </div>
                                                                </div>

                                                                <div class="col-9 offset-md-3 offset-1 dependency">
                                                                    <div class="d-flex">
                                                                        <div class="ltr:me-3 rtl:ms-3">
                                                                            <input type="hidden" name="review_left"
                                                                                value="0">
                                                                            <div class="switch switch-bg d-inline m-r-10">
                                                                                <input type="checkbox" name="review_left"
                                                                                    id="review_left" value="1"
                                                                                    <?php echo e(preference('review_left', '') == 1 ? 'checked' : ''); ?>>
                                                                                <label for="review_left"
                                                                                    class="cr"></label>
                                                                            </div>
                                                                        </div>
                                                                        <div class="mt-2">
                                                                            <span><?php echo e(__("Reviews can only be left by 'verified owners'")); ?></span>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="form-group row mt-25 dependency">
                                                                <label for="rating"
                                                                    class="col-sm-3 control-label text-left"><?php echo e(__('Ratings')); ?></label>
                                                                <div class="col-9 d-flex mt-neg-2">
                                                                    <div class="ltr:me-3 rtl:ms-3">
                                                                        <input type="hidden" name="rating_enable"
                                                                            value="0">
                                                                        <div class="switch switch-bg d-inline m-r-10">
                                                                            <input type="checkbox" name="rating_enable"
                                                                                class="checkActivity" id="rating_enable"
                                                                                value="1"
                                                                                <?php echo e(preference('rating_enable', '') == 1 ? 'checked' : ''); ?>>
                                                                            <label for="rating_enable"
                                                                                class="cr"></label>
                                                                        </div>
                                                                    </div>
                                                                    <div class="mt-2">
                                                                        <span><?php echo e(__('Enable star rating on reviews')); ?></span>
                                                                    </div>
                                                                </div>

                                                                <div class="col-9 offset-md-3 offset-1 dependency">
                                                                    <div class="d-flex">
                                                                        <div class="ltr:me-3 rtl:ms-3">
                                                                            <input type="hidden" name="rating_required"
                                                                                value="0">
                                                                            <div class="switch switch-bg d-inline m-r-10">
                                                                                <input type="checkbox"
                                                                                    name="rating_required"
                                                                                    id="rating_required" value="1"
                                                                                    <?php echo e(preference('rating_required', '') == 1 ? 'checked' : ''); ?>>
                                                                                <label for="rating_required"
                                                                                    class="cr"></label>
                                                                            </div>
                                                                        </div>
                                                                        <div class="mt-2">
                                                                            <span><?php echo e(__('Star ratings should be required, not optional')); ?></span>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="form-group row">
                                                                <label for="wishlist"
                                                                    class="col-sm-3 control-label"><?php echo e(__('Wishlist')); ?></label>
                                                                <div class="col-9 d-flex">
                                                                    <div class="ltr:me-3 rtl:ms-3">
                                                                        <input type="hidden" name="wishlist"
                                                                            value="0">
                                                                        <div class="switch switch-bg d-inline m-r-10">
                                                                            <input type="checkbox" name="wishlist"
                                                                                class="checkActivity" id="wishlist"
                                                                                value="1"
                                                                                <?php echo e(preference('wishlist', '') == 1 ? 'checked' : ''); ?>>
                                                                            <label for="wishlist" class="cr"></label>
                                                                        </div>
                                                                    </div>
                                                                    <div class="mt-2">
                                                                        <span><?php echo e(__('Enable Wishlist')); ?></span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="form-group row">
                                                                <label for="compare"
                                                                    class="col-sm-3 control-label"><?php echo e(__('Compare')); ?></label>
                                                                <div class="col-9 d-flex">
                                                                    <div class="ltr:me-3 rtl:ms-3">
                                                                        <input type="hidden" name="compare"
                                                                            value="0">
                                                                        <div class="switch switch-bg d-inline m-r-10">
                                                                            <input type="checkbox" name="compare"
                                                                                class="checkActivity" id="compare"
                                                                                value="1"
                                                                                <?php echo e(preference('compare', '') == 1 ? 'checked' : ''); ?>>
                                                                            <label for="compare" class="cr"></label>
                                                                        </div>
                                                                    </div>
                                                                    <div class="mt-2">
                                                                        <span><?php echo e(__('Enable Compare')); ?></span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-footer p-0">
                                                <div class="form-group row">
                                                    <label for="btn_save" class="col-sm-3 control-label"></label>
                                                    <div class="col-sm-12">
                                                        <button type="submit"
                                                            class="btn form-submit custom-btn-submit ltr:float-right rtl:float-left save-button"
                                                            id="footer-btn">
                                                            <span
                                                                class="d-none product-spinner spinner-border spinner-border-sm text-secondary"
                                                                role="status"></span>
                                                            <?php echo e(__('Save')); ?>

                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="tab-pane fade parent" id="v-pills-inventory" role="tabpanel"
                                aria-labelledby="v-pills-inventory-tab">
                                <div class="noti-alert pad no-print warningMessage mt-2">
                                    <div class="alert warning-message abc">
                                        <strong id="warning-msg" class="msg"></strong>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <form action="<?php echo e(route('product.setting.inventory')); ?>" method="post"
                                            class="form-horizontal product_setting_form">
                                            <?php echo csrf_field(); ?>
                                            <div class="card-body border-bottom table-border-style p-0">
                                                <div class="form-tabs">
                                                    <div class="tab-content box-shadow-unset px-0 py-2">
                                                        <div class="tab-pane fade show active" id="home"
                                                            role="tabpanel" aria-labelledby="home-tab">
                                                            <div class="form-group row">
                                                                <label for="manage_stock"
                                                                    class="col-sm-3 control-label"><?php echo e(__('Manage Stock')); ?></label>
                                                                <div class="col-9 d-flex mt-neg-2">
                                                                    <div class="ltr:me-3 rtl:ms-3">
                                                                        <input type="hidden" name="manage_stock"
                                                                            value="0">
                                                                        <div class="switch switch-bg d-inline m-r-10">
                                                                            <input type="checkbox" name="manage_stock"
                                                                                class="checkActivity" id="manage_stock"
                                                                                value="1"
                                                                                <?php echo e(preference('manage_stock', '') == 1 ? 'checked' : ''); ?>>
                                                                            <label for="manage_stock"
                                                                                class="cr"></label>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="form-group row dependency">
                                                                <label for="hold_stock"
                                                                    class="col-sm-3 control-label"><?php echo e(__('Hold stock (minutes)')); ?></label>
                                                                <div class="col-9">
                                                                    <div class="col-4 pl-0">
                                                                        <input type="number"
                                                                            class="form-control form-height"
                                                                            name="hold_stock" id="hold_stock"
                                                                            min="0"
                                                                            value="<?php echo e(preference('hold_stock', '0')); ?>">
                                                                    </div>
                                                                    <div class="mt-2">
                                                                        <span><?php echo e(__('X minutes (Hold stock (for unpaid orders) for x minutes. When this limit is reached, the pending order will be canceled. Leave blank to disable.)')); ?></span>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="form-group row dependency">
                                                                <label for="notification"
                                                                    class="col-sm-3 control-label text-left"><?php echo e(__('Notifications')); ?></label>
                                                                <div class="col-9 d-flex mt-neg-2">
                                                                    <div class="ltr:me-3 rtl:ms-3">
                                                                        <input type="hidden"
                                                                            name="notification_low_stock" value="0">
                                                                        <div class="switch switch-bg d-inline m-r-10">
                                                                            <input type="checkbox"
                                                                                name="notification_low_stock"
                                                                                id="notification_low_stock" value="1"
                                                                                <?php echo e(preference('notification_low_stock', '') == 1 ? 'checked' : ''); ?>>
                                                                            <label for="notification_low_stock"
                                                                                class="cr"></label>
                                                                        </div>
                                                                    </div>
                                                                    <div class="mt-2">
                                                                        <span><?php echo e(__('Enable low stock notifications')); ?></span>
                                                                    </div>
                                                                </div>

                                                                <div class="col-9 offset-3 dependency">
                                                                    <div class="d-flex">
                                                                        <div class="ltr:me-3 rtl:ms-3">
                                                                            <input type="hidden"
                                                                                name="notification_out_of_stock"
                                                                                value="0">
                                                                            <div class="switch switch-bg d-inline m-r-10">
                                                                                <input type="checkbox"
                                                                                    name="notification_out_of_stock"
                                                                                    id="notification_out_of_stock"
                                                                                    value="1"
                                                                                    <?php echo e(preference('notification_out_of_stock', '') == 1 ? 'checked' : ''); ?>>
                                                                                <label for="notification_out_of_stock"
                                                                                    class="cr"></label>
                                                                            </div>
                                                                        </div>
                                                                        <div class="mt-2">
                                                                            <span><?php echo e(__('Enable out of stock notifications')); ?></span>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="form-group row dependency mt-25">
                                                                <label for="stock_threshold"
                                                                    class="col-sm-3 control-label text-left"><?php echo e(__('Low and Out of stock threshold')); ?></label>
                                                                <div class="col-sm-1">
                                                                    <input type="hidden" name="stock_threshold"
                                                                        value="0">
                                                                    <div class="switch switch-bg d-inline m-r-10">
                                                                        <input type="checkbox" name="stock_threshold"
                                                                            id="stock_threshold" value="1"
                                                                            <?php echo e(preference('stock_threshold', '') == 1 ? 'checked' : ''); ?>>
                                                                        <label for="stock_threshold"
                                                                            class="cr"></label>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="form-group row dependency">
                                                                <label for="out_of_stock_visibility"
                                                                    class="col-sm-3 control-label text-left"><?php echo e(__('Out of stock visibility')); ?></label>
                                                                <div class="col-9 d-flex mt-neg-2">
                                                                    <div class="ltr:me-3 rtl:ms-3">
                                                                        <input type="hidden"
                                                                            name="out_of_stock_visibility" value="0">
                                                                        <div class="switch switch-bg d-inline m-r-10">
                                                                            <input type="checkbox"
                                                                                name="out_of_stock_visibility"
                                                                                id="out_of_stock_visibility"
                                                                                value="1"
                                                                                <?php echo e(preference('out_of_stock_visibility', '') == 1 ? 'checked' : ''); ?>>
                                                                            <label for="out_of_stock_visibility"
                                                                                class="cr"></label>
                                                                        </div>
                                                                    </div>
                                                                    <div class="mt-2">
                                                                        <span><?php echo e(__('Hide out of stock products from the catalog')); ?></span>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="form-group row">
                                                                <label for="stock_display_format"
                                                                    class="col-sm-3 control-label text-left"><?php echo e(__('Stock display format')); ?></label>
                                                                <div class="col-md-9 col-12">
                                                                    <div class="row radio">
                                                                        <div class="col-sm-12 mb-2">
                                                                            <div class="mb-2 radio radio-warning d-inline">
                                                                                <input type="radio" id="always_show"
                                                                                    name="stock_display_format"
                                                                                    <?php echo e(preference('stock_display_format') ? '' : 'checked'); ?>

                                                                                    value="always_show"
                                                                                    <?php echo e(preference('stock_display_format', '') == 'always_show' ? 'checked' : ''); ?>>
                                                                                <label class="cr custom"
                                                                                    for="always_show"></label>
                                                                                <label
                                                                                    class="w-75"><?php echo e(__("Always show quantity remaining in stock e.g. '2 in stock'")); ?></label>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-sm-12 mb-2">
                                                                            <div class="mb-2 radio radio-warning d-inline">
                                                                                <input type="radio" id="sometime_show"
                                                                                    name="stock_display_format"
                                                                                    value="sometime_show"
                                                                                    <?php echo e(preference('stock_display_format', '') == 'sometime_show' ? 'checked' : ''); ?>>
                                                                                <label class="cr custom"
                                                                                    for="sometime_show"></label>
                                                                                <label
                                                                                    class="w-75"><?php echo e(__("Only show quantity remaining in stock when low e.g. 'Only 2 left in stock'")); ?></label>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-sm-12">
                                                                            <div class="radio mb-2 radio-warning d-inline">
                                                                                <input type="radio" id="never_show"
                                                                                    name="stock_display_format"
                                                                                    value="never_show"
                                                                                    <?php echo e(preference('stock_display_format', '') == 'never_show' ? 'checked' : ''); ?>>
                                                                                <label class="cr custom"
                                                                                    for="never_show"></label>
                                                                                <label><?php echo e(__('Never show quantity remaining in stock')); ?></label>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-footer p-0">
                                                <div class="form-group row">
                                                    <label for="btn_save" class="col-sm-3 control-label"></label>
                                                    <div class="col-sm-12">
                                                        <button type="submit"
                                                            class="btn form-submit custom-btn-submit ltr:float-right rtl:float-left save-button"
                                                            id="footer-btn">
                                                            <span
                                                                class="d-none product-spinner spinner-border spinner-border-sm text-secondary"
                                                                role="status"></span>
                                                            <?php echo e(__('Save')); ?>

                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="tab-pane fade parent" id="v-pills-vendor" role="tabpanel"
                                aria-labelledby="v-pills-vendor-tab">
                                <div class="noti-alert pad no-print warningMessage mt-2">
                                    <div class="alert warning-message abc">
                                        <strong id="warning-msg" class="msg"></strong>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <form action="<?php echo e(route('product.setting.vendor')); ?>" method="post"
                                            class="form-horizontal product_setting_form">
                                            <?php echo csrf_field(); ?>
                                            <div class="card-body border-bottom table-border-style p-0">
                                                <div class="form-tabs">
                                                    <div class="tab-content box-shadow-unset px-0 py-2">
                                                        <div class="tab-pane fade show active" id="home"
                                                            role="tabpanel" aria-labelledby="home-tab">
                                                            <div class="form-group row">
                                                                <label for="is_publish_product"
                                                                    class="col-sm-3 control-label text-left"><?php echo e(__('Publish Product')); ?></label>
                                                                <div class="col-9 d-flex mt-neg-2">
                                                                    <div class="ltr:me-3 rtl:ms-3">
                                                                        <input type="hidden" name="is_publish_product"
                                                                            value="0">
                                                                        <div class="switch switch-bg d-inline m-r-10">
                                                                            <input type="checkbox"
                                                                                name="is_publish_product"
                                                                                id="is_publish_product" value="1"
                                                                                <?php echo e(preference('is_publish_product', '') == 1 ? 'checked' : ''); ?>>
                                                                            <label for="is_publish_product"
                                                                                class="cr"></label>
                                                                        </div>
                                                                    </div>
                                                                    <div class="mt-2">
                                                                        <span><?php echo e(__('Without admin review, vendor can publish product directly.')); ?></span>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="form-group row">
                                                                <label for="notification"
                                                                    class="col-sm-3 control-label text-left"><?php echo e(__('Withdrawal Method')); ?></label>
                                                                <div class="col-9 d-flex mt-neg-2">
                                                                    <div class="ltr:me-3 rtl:ms-3">
                                                                        <input type="hidden" name="paypal"
                                                                            value="Inactive">
                                                                        <div class="switch switch-bg d-inline m-r-10">
                                                                            <input type="checkbox" name="paypal"
                                                                                id="paypal" value="Active"
                                                                                <?php echo e($withdrawalMethods->where('method_name', 'Paypal')->first()->status == 'Active' ? 'checked' : ''); ?>>
                                                                            <label for="paypal" class="cr"></label>
                                                                        </div>
                                                                    </div>
                                                                    <div class="mt-2">
                                                                        <span><?php echo e(__('Paypal')); ?></span>
                                                                    </div>
                                                                </div>

                                                                <div class="col-9 offset-3">
                                                                    <div class="d-flex">
                                                                        <div class="ltr:me-3 rtl:ms-3">
                                                                            <input type="hidden" name="bank"
                                                                                value="Inactive">
                                                                            <div class="switch switch-bg d-inline m-r-10">
                                                                                <input type="checkbox" name="bank"
                                                                                    id="bank" value="Active"
                                                                                    <?php echo e($withdrawalMethods->where('method_name', 'Bank')->first()->status == 'Active' ? 'checked' : ''); ?>>
                                                                                <label for="bank"
                                                                                    class="cr"></label>
                                                                            </div>
                                                                        </div>
                                                                        <div class="mt-2">
                                                                            <span><?php echo e(__('Bank')); ?></span>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="form-group row">
                                                                <label for="is_active"
                                                                    class="col-sm-3 control-label"><?php echo e(__('Manage Commission')); ?></label>
                                                                <div class="col-sm-1 margin-neg-top-05">
                                                                    <input type="hidden" name="is_active"
                                                                        value="0">
                                                                    <div class="switch switch-bg d-inline m-r-10">
                                                                        <input type="checkbox" name="is_active"
                                                                            class="checkActivity" id="is_active"
                                                                            value="1"
                                                                            <?php echo e(isset($commission['is_active']) && $commission['is_active'] == 1 ? 'checked' : ''); ?>>
                                                                        <label for="is_active" class="cr"></label>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="form-group row dependency">
                                                                <label for="is_category_based"
                                                                    class="col-sm-3 control-label text-left"><?php echo e(__('Category based commission')); ?></label>
                                                                <div class="col-sm-1 margin-neg-top-05">
                                                                    <input type="hidden" name="is_category_based"
                                                                        value="0">
                                                                    <div class="switch switch-bg d-inline m-r-10">
                                                                        <input type="checkbox" name="is_category_based"
                                                                            id="is_category_based" value="1"
                                                                            <?php echo e(isset($commission['is_category_based']) && $commission['is_category_based'] == 1 ? 'checked' : ''); ?>>
                                                                        <label for="is_category_based"
                                                                            class="cr"></label>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="form-group row dependency">
                                                                <label for="amount"
                                                                    class="col-sm-3 control-label"><?php echo e(__('Default Commission')); ?></label>
                                                                <div class="col-9">
                                                                    <div class="col-4 pl-0">
                                                                        <input type="text" min="0"
                                                                            class="form-control positive-float-number form-height"
                                                                            name="amount" id="amount"
                                                                            value="<?php echo e(isset($commission['amount']) ? formatCurrencyAmount($commission['amount']) : 0); ?>">
                                                                    </div>
                                                                    <div class="mt-2">
                                                                        <span><?php echo e(__('Enter a default commission that works globally for all vendors as a fallback if the commission is not set per vendor or category level. Enter a positive number.')); ?></span>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="form-group row">
                                                                <label for="chat"
                                                                    class="col-sm-3 control-label"><?php echo e(__('Chat')); ?></label>
                                                                <div class="col-9 d-flex">
                                                                    <div class="ltr:me-3 rtl:ms-3">
                                                                        <input type="hidden" name="chat"
                                                                            value="0">
                                                                        <div class="switch switch-bg d-inline m-r-10">
                                                                            <input type="checkbox" name="chat"
                                                                                class="checkActivity" id="chat"
                                                                                value="1"
                                                                                <?php echo e(preference('chat', '') == 1 ? 'checked' : ''); ?>>
                                                                            <label for="chat" class="cr"></label>
                                                                        </div>
                                                                    </div>
                                                                    <div class="mt-2">
                                                                        <span><?php echo e(__('Enable Chat')); ?></span>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="form-group row">
                                                                <label for="access_system_category"
                                                                       class="col-sm-3 control-label"><?php echo e(__('Access Global Category')); ?></label>
                                                                <div class="col-9 d-flex">
                                                                    <div class="ltr:me-3 rtl:ms-3">
                                                                        <input type="hidden" name="access_system_category"
                                                                            value="0">
                                                                        <div class="switch switch-bg d-inline m-r-10">
                                                                            <input type="checkbox" name="access_system_category"
                                                                                class="checkActivity" id="access_system_category"
                                                                                value="1"
                                                                                <?php echo e(preference('access_system_category', '') == 1 ? 'checked' : ''); ?>>
                                                                            <label for="access_system_category" class="cr"></label>
                                                                        </div>
                                                                    </div>
                                                                    <div class="mt-2">
                                                                        <span><?php echo e(__('Without enabling this option, the vendor can not access the system category or use System Category Suggestion.')); ?></span>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="form-group row">
                                                                <label for="vendor_category"
                                                                    class="col-sm-3 control-label"><?php echo e(__('Custom Category')); ?></label>
                                                                <div class="col-9 d-flex">
                                                                    <div class="ltr:me-3 rtl:ms-3">
                                                                        <input type="hidden" name="vendor_category"
                                                                            value="0">
                                                                        <div class="switch switch-bg d-inline m-r-10">
                                                                            <input type="checkbox" name="vendor_category"
                                                                                class="checkActivity" id="vendor_category"
                                                                                value="1"
                                                                                <?php echo e(preference('vendor_category', '') == 1 ? 'checked' : ''); ?>>
                                                                            <label for="vendor_category" class="cr"></label>
                                                                        </div>
                                                                    </div>
                                                                    <div class="mt-2">
                                                                        <span><?php echo e(__('Enabling this option, the vendor can create their own category from vendor panel.')); ?></span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            
                                                            <div class="form-group row dependency">
                                                                <label for="system_suggestion"
                                                                    class="col-sm-3 control-label text-left"><?php echo e(__('Global Category Suggestion')); ?></label>
                                                                <div class="col-9 d-flex">
                                                                    <div class="ltr:me-3 rtl:ms-3">
                                                                        <input type="hidden" name="system_suggestion"
                                                                            value="0">
                                                                        <div class="switch switch-bg d-inline m-r-10">
                                                                            <input type="checkbox" name="system_suggestion"
                                                                                id="system_suggestion" value="1"
                                                                                <?php echo e(preference('system_suggestion', '') == 1 ? 'checked' : ''); ?>>
                                                                            <label for="system_suggestion"
                                                                                class="cr"></label>
                                                                        </div>
                                                                    </div>
                                                                    <div class="mt-2">
                                                                        <span><?php echo e(__('Enabling this option allows the vendor to see suggestions when creating a category.')); ?></span>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="form-group row dependency">
                                                                <label for="vendor_cat_commission"
                                                                       class="col-sm-3 control-label"><?php echo e(__('Default Commission')); ?></label>
                                                                <div class="col-9">
                                                                    <div class="col-4 pl-0">
                                                                        <input type="text" min="0"
                                                                               class="form-control positive-float-number form-height"
                                                                               name="vendor_cat_commission" id="vendor_cat_commission"
                                                                               value="<?php echo e(formatCurrencyAmount(preference('vendor_cat_commission', ''))); ?>">
                                                                    </div>
                                                                    <div class="mt-2">
                                                                        <span><?php echo e(__('Enter a default commission that works for new vendor created category.')); ?></span>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="form-group row">
                                                                <label for="is_vendor_customer_list_active"
                                                                    class="col-sm-3 control-label"><?php echo e(__('Customer list')); ?></label>
                                                                <div class="col-9 d-flex">
                                                                    <div class="ltr:me-3 rtl:ms-3">
                                                                        <input type="hidden" name="is_vendor_customer_list_active"
                                                                            value="0">
                                                                        <div class="switch switch-bg d-inline m-r-10">
                                                                            <input type="checkbox" name="is_vendor_customer_list_active"
                                                                                class="checkActivity" id="is_vendor_customer_list_active"
                                                                                value="1"
                                                                                <?php echo e(preference('is_vendor_customer_list_active', '') == 1 ? 'checked' : ''); ?>>
                                                                            <label for="is_vendor_customer_list_active" class="cr"></label>
                                                                        </div>
                                                                    </div>
                                                                    <div class="mt-2">
                                                                        <span><?php echo e(__('When this option is enabled, the vendor can view the list of their customers in the vendor panel.')); ?></span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            
                                                            <div class="form-group row">
                                                                <label for="is_vendor_shop_decoration_active"
                                                                    class="col-sm-3 control-label"><?php echo e(__('Shop Decoration')); ?></label>
                                                                <div class="col-9 d-flex">
                                                                    <div class="ltr:me-3 rtl:ms-3">
                                                                        <input type="hidden" name="is_vendor_shop_decoration_active"
                                                                            value="0">
                                                                        <div class="switch switch-bg d-inline m-r-10">
                                                                            <input type="checkbox" name="is_vendor_shop_decoration_active"
                                                                                class="checkActivity" id="is_vendor_shop_decoration_active"
                                                                                value="1"
                                                                                <?php echo e(preference('is_vendor_shop_decoration_active', '') == 1 ? 'checked' : ''); ?>>
                                                                            <label for="is_vendor_shop_decoration_active" class="cr"></label>
                                                                        </div>
                                                                    </div>
                                                                    <div class="mt-2">
                                                                        <span><?php echo e(__('When this option is enabled, the vendor can view the shop decoration in the vendor panel.')); ?></span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-footer p-0">
                                                <div class="form-group row">
                                                    <label for="btn_save" class="col-sm-3 control-label"></label>
                                                    <div class="col-sm-12">
                                                        <button type="submit"
                                                            class="btn form-submit custom-btn-submit ltr:float-right rtl:float-left save-button"
                                                            id="footer-btn">
                                                            <span
                                                                class="d-none product-spinner spinner-border spinner-border-sm text-secondary"
                                                                role="status"></span>
                                                            <?php echo e(__('Save')); ?>

                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('public/dist/js/custom/validation.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/js/condition.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/js/custom/product-setting.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/creativedesignbd/ecommerce9.creativedesign.com.bd/resources/views/admin/product_settings/index.blade.php ENDPATH**/ ?>