<?php

namespace Modules\Paypal\Services\Orders;

use PayPalHttp\HttpRequest;

class OrdersCaptureRequest extends HttpRequest
{
    public function __construct($orderId)
    {
        parent::__construct('/v2/checkout/orders/{order_id}/capture?', 'POST');

        $this->path = str_replace('{order_id}', urlencode($orderId), $this->path);
        $this->headers['Content-Type'] = 'application/json';
    }

    public function payPalClientMetadataId($payPalClientMetadataId)
    {
        $this->headers['PayPal-Client-Metadata-Id'] = $payPalClientMetadataId;
    }

    public function payPalRequestId($payPalRequestId)
    {
        $this->headers['PayPal-Request-Id'] = $payPalRequestId;
    }

    public function prefer($prefer)
    {
        $this->headers['Prefer'] = $prefer;
    }
}
