<?php

/**
 * @author TechVillage <support@techvill.org>
 *
 * @contributor Ashraful Rasel <[ashraful.techvill@gmail.com]>
 *
 * @created 11-11-2024
 */

namespace Modules\UddoktaPay\Views;

use Modules\Gateway\Contracts\PaymentViewInterface;
use Modules\Gateway\Services\GatewayHelper;
use Modules\Gateway\Traits\ApiResponse;
use Modules\UddoktaPay\Entities\UddoktaPay;

class UddoktaPayView implements PaymentViewInterface
{
    use ApiResponse;

    public static function paymentView($key)
    {
        $helper = GatewayHelper::getInstance();

        try {
            $uddoktaPay = UddoktaPay::firstWhere('alias', 'uddoktapay')->data;

            return view('uddoktapay::pay', [
                'apiKey' => $uddoktaPay->apiKey,
                'instruction' => $uddoktaPay->instruction,
                'purchaseData' => $helper->getPurchaseData($key),
            ]);
        } catch (\Exception $e) {
            return back()->withErrors(['error' => __('Purchase data not found.')]);
        }
    }

    public static function paymentResponse($key)
    {
        $helper = GatewayHelper::getInstance();

        $uddoktaPay = UddoktaPay::firstWhere('alias', 'uddoktapay')->data;

        return [
            'apiKey' => $uddoktaPay->apiKey,
            'instruction' => $uddoktaPay->instruction,
            'purchaseData' => $helper->getPurchaseData($key),
        ];
    }
}
