@extends('vendor.layouts.app')
@section('page_title', __('View :x', ['x' => __('Invoice')]))
@section('css')
    <!-- date range picker css -->
    <link rel="stylesheet" href="{{ asset('public/dist/plugins/bootstrap-daterangepicker/daterangepicker.min.css') }}">
    <!-- select2 css -->
    <link rel="stylesheet" href="{{ asset('public/datta-able/plugins/select2/css/select2.min.css') }}">
@endsection
@section('content')

    <!-- Main content -->
    <div class="order-details-container" id="vendor-order-view-container">
        {{-- Notification --}}
        <div class="col-md-12 no-print notification-msg-bar smoothly-hide">
            <div class="noti-alert pad">
                <div class="alert bg-dark text-light m-0 text-center">
                    <span class="notification-msg"></span>
                </div>
            </div>
        </div>

        <div>
            @php
                $sections = (new \App\Services\Order\Section)->getSections();
            @endphp
            @foreach ($sections as $key => $section)
                @if (
                    ($section['visibility'] ?? '1') == '1' 
                    && ($section['is_main'] ?? false)
                    && $section['vendor_content'] ?? false)
                    @if (is_callable($section['vendor_content']))
                        {!! $section['vendor_content']() !!}
                    @else
                        @includeIf($section['vendor_content'])
                    @endif
                @endif
            @endforeach
        </div>
        <div class="order-actions-container">
            @foreach ($sections as $key => $section)
                @if (
                    ($section['visibility'] ?? '1') == '1' 
                    && !($section['is_main'] ?? false)
                    && $section['vendor_content'] ?? false)
                    @if (is_callable($section['vendor_content']))
                        {!! $section['vendor_content']() !!}
                    @else
                        @includeIf($section['vendor_content'])
                    @endif
                @endif
            @endforeach
        </div>

        <div id="refund-store" class="modal fade display_none" role="dialog">
            <div class="modal-dialog">

                <!-- Modal content-->
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">{{ __('Refund') }} &nbsp; </h4>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form action="{{ route('site.orderRefund') }}" method="post" class="form-horizontal">
                            @csrf
                            <input type="hidden" name="quantity_sent" id="quantity_sent" value="1">
                            <input type="hidden" name="order_detail_id" id="order_detail_id">
                            <input type="hidden" name="type" value="admin">
                            <div class="form-group row mb-3">
                                <label class="col-3 control-label" for="inputEmail3">{{ __('Quantity') }}</label>
                                <div class="col-6 d-flex align-items-center">
                                    <a href="javascript:void(0)" class="text-center px-3 py-2 border" id="refundQtyDec"><span class="inline-block">-</span></a>
                                    <div class="px-3" id="refundQty">1</div>
                                    <a href="javascript:void(0)" class="text-center px-3 py-2 border" id="refundQtyInc"><span class="inline-block">+</span></a>
                                </div>
                            </div>
                            <div class="form-group row mt-3 mt-md-0">
                                <label class="col-3 control-label pe-0" for="inputEmail3">{{ __('Reason') }}</label>
                                <div class="col-8">
                                    <select class="form-control select2" name="refund_reason_id">
                                        @foreach ($refundReasons as $reason)
                                            <option value="{{ $reason->id }}">{{ $reason->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row mt-3">
                                <label class="col-3 control-label pe-0" for="is_default"></label>
                                <div class="col-8">
                                    <textarea name="comment" class="form-control" placeholder="{{ __('Please let me know, why are you want to refund this item.') }}" rows="5"></textarea>
                                </div>
                            </div>
                            <div class="form-group row mt-3 mt-md-0">
                                <div class="col-sm-12">
                                    <button type="submit" class="btn custom-btn-submit float-right">{{ __('Submit') }}</button>
                                    <button type="button" class="btn custom-btn-cancel all-cancel-btn float-right" data-dismiss="modal">{{ __('Close') }}</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    <script>
        'use strict';
        var orderId = "{{ $order->id }}";
        var paymentStatus = "{{ $order->payment_status }}";
        var finalOrderStatus = "{{ $finalOrderStatus }}";
        var orderUrl = "{{ route('vendorOrder.update') }}";
        var vendorId = "{{ auth()->user()->vendor()->vendor_id }}";
        var orderView = "vendor";
    </script>
    <script src="{{ asset('public/dist/js/custom/common.min.js') }}"></script>
    <!-- select2 JS -->
    <script src="{{ asset('public/datta-able/plugins/select2/js/select2.full.min.js') }}"></script>
    <script src="{{ asset('public/dist/js/custom/invoice.min.js') }}"></script>
    <script src="{{ asset('public/dist/js/custom/jquery.blockUI.min.js') }}"></script>
    <script src="{{ asset('public/dist/js/custom/order.min.js') }}"></script>
@endsection
