
<div id="edit-country" class="modal fade display_none" aria-modal="true" role="dialog">
    <div class="modal-dialog">
        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title"><?php echo e(__('Edit :x', ['x' => __('Country')])); ?></h4>
                <a type="button" class="close h5" data-bs-dismiss="modal">×</a>
            </div>
            <form method="post" id="edut_country"
                class="form-horizontal">
                <?php echo csrf_field(); ?>
                <div class="ajax-content">
                    <input type="hidden" name="continent_id" value="1">
                    <input type="hidden" name="has_division" value="1">
                </div>
                <div class="modal-body">
                    <div class="form-group row">
                        <label class="col-sm-4 control-label require" for="name"><?php echo e(__('Name')); ?></label>
                        <div class="col-sm-7">
                            <input type="text" class="form-control inputFieldDesign" name="name" placeholder="<?php echo e(__('Name')); ?>" id="name"
                                required oninvalid="this.setCustomValidity('<?php echo e(__('This field is required.')); ?>')"
                                minlength="3" data-min-length="<?php echo e(__(':x should be at least :y characters.', ['x' => __('Name'), 'y' => 3])); ?>">
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-4 control-label" for="full_name"><?php echo e(__('Full Name')); ?></label>
                        <div class="col-sm-7">
                            <input type="text" class="form-control inputFieldDesign" name="full_name" placeholder="<?php echo e(__('Full Name')); ?>" id="full_name"
                                minlength="3" data-min-length="<?php echo e(__(':x should be at least :y characters.', ['x' => __('Full Name'), 'y' => 3])); ?>">
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-4 control-label" for="capital"><?php echo e(__('Capital')); ?></label>
                        <div class="col-sm-7">
                            <input type="text" class="form-control" name="capital" placeholder="<?php echo e(__('Capital')); ?>" id="capital"
                                pattern="[a-zA-Z-.' ]*$" data-pattern="<?php echo e(__("Only alphabet, [- ' .] and white space are allowed.")); ?>">
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-4 control-label require" for="code"><?php echo e(__('Code')); ?></label>
                        <div class="col-sm-7">
                            <input type="text" class="form-control inputFieldDesign" name="code" placeholder="<?php echo e(__('Code')); ?>" id="code" maxlength="2"
                                required oninvalid="this.setCustomValidity('<?php echo e(__('This field is required.')); ?>')"
                                minlength="2" data-min-length="<?php echo e(__(':x should be at least :y characters.', ['x' => __('Code'), 'y' => 2])); ?>">
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-4 control-label" for="code_alpha3"><?php echo e(__('3 character code')); ?></label>
                        <div class="col-sm-7">
                            <input type="text" class="form-control inputFieldDesign" name="code_alpha3" placeholder="<?php echo e(__('3 character code')); ?>" id="code_alpha3"
                            maxlength="3"
                            minlength="3" data-min-length="<?php echo e(__(':x should be at least :y characters.', ['x' => __('3 character code'), 'y' => 3])); ?>">
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-4 control-label" for="code_numeric"><?php echo e(__('Numeric code')); ?></label>
                        <div class="col-sm-7">
                            <input type="number" class="form-control inputFieldDesign" name="code_numeric" placeholder="<?php echo e(__('Numeric code')); ?>" id="code_numeric"
                                max="999999"
                                data-max="<?php echo e(__(':x should be at most :y digits.', ['x' => __('Numeric code'), 'y' => 6])); ?>">
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-4 control-label" for="emoji"><?php echo e(__('Emoji')); ?></label>
                        <div class="col-sm-7">
                            <input type="text" class="form-control inputFieldDesign" name="emoji" placeholder="<?php echo e(__('Emoji')); ?>" id="emoji">
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-4 control-label" for="currency_code"><?php echo e(__('Currency Code')); ?></label>
                        <div class="col-sm-7">
                            <input type="text" class="form-control inputFieldDesign"
                                name="currency_code"
                                placeholder="<?php echo e(__('Currency Code')); ?>"
                                id="currency_code"
                                maxlength="3"
                                minlength="3"
                                data-min-length="<?php echo e(__(':x must be :y characters.', ['x' => __('Currency Code'), 'y' => 3])); ?>">
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-4 control-label" for="currency_name"><?php echo e(__('Currency Name')); ?></label>
                        <div class="col-sm-7">
                            <input type="text" class="form-control inputFieldDesign"
                                name="currency_name"
                                placeholder="<?php echo e(__('Currency Name')); ?>"
                                id="currency_name"
                                minlength="3"
                                data-min-length="<?php echo e(__(':x should be at least :y characters.', ['x' => __('Currency Name'), 'y' => 3])); ?>">
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-4 control-label" for="currency_symbol"><?php echo e(__('Currency Symbol')); ?></label>
                        <div class="col-sm-7">
                            <input type="text" class="form-control inputFieldDesign"
                                name="currency_symbol"
                                placeholder="<?php echo e(__('Example')); ?>: ৳, $, €"
                                id="currency_symbol">
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-4 control-label" for="tld"><?php echo e(__('Top Level Domain')); ?></label>
                        <div class="col-sm-7">
                            <input type="text" class="form-control inputFieldDesign" name="tld" placeholder="<?php echo e(__('Top Level Domain')); ?>" id="tld">
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-4 control-label" for="callingcode"><?php echo e(__('Calling code')); ?></label>
                        <div class="col-sm-7">
                            <input type="text" class="form-control positive-int-number inputFieldDesign" name="callingcode" placeholder="<?php echo e(__('Calling code')); ?>" id="callingcode"
                                maxlength="4"
                                data-max-length="<?php echo e(__(':x should be at most :y characters.', ['x' => __('Calling code'), 'y' => 4])); ?>">
                        </div>
                    </div>
                </div>
                <div class="modal-footer py-0">
                    <div class="form-group row">
                        <label for="btn_save" class="col-sm-3 control-label"></label>
                        <div class="col-sm-12">
                            <button type="submit"
                            class="btn custom-btn-submit ltr:float-right rtl:float-left"><?php echo e(__('Update')); ?></button>
                            <button type="button" class="py-2 custom-btn-cancel ltr:float-right ltr:me-2 rtl:float-left rtl:ms-2" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<?php /**PATH /home/creativedesignbd/ecommerce9.creativedesign.com.bd/Modules/GeoLocale/Resources/views/includes/edit-country.blade.php ENDPATH**/ ?>