<div class="card code-table h-100">
    <div class="card-header d-flex justify-content-between">
        <h5 class="text-uppercase"><?php echo e(__('Most sold brands')); ?></h5>
    </div>
    <div class="card-block pb-0 h-300">
        <div>
            <table class="table table-hover" id="most-sold-brands">
                <?php if(count($topSoldBrands)): ?>
                    <thead class="bg-inherit">
                        <tr>
                            <th><?php echo e(__('Brand')); ?></th>
                            <th class="text-right"><?php echo e(__('Total')); ?></th>
                        </tr>
                    </thead>
                <?php endif; ?>

                <tbody class="original-data">
                    <?php $__empty_1 = true; $__currentLoopData = $topSoldBrands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td class="unread">
                                <?php if( $brand['url'] == ''): ?>
                                    <span><?php echo e($brand['name']); ?></span>
                                <?php else: ?>
                                    <a href="<?php echo e($brand['url']); ?>" class="mb-0" target="_blank"><?php echo e($brand['name']); ?></a>
                                <?php endif; ?>
                            </td>
                            <td class="text-right">
                                <?php echo e($brand['total']); ?>

                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr class="border-0">
                            <td colspan="2" class="border-0"><?php echo e(__('No data found.')); ?></td>
                        </tr>
                    <?php endif; ?>

                </tbody>

                <tbody class="placeholder-data d-none">
                    <tr>
                        <td>
                            <div class="placeholder wave h-16p">
                                <div class="square"></div>
                            </div>
                        </td>
                        <td>
                            <div class="placeholder wave h-16p">
                                <div class="square"></div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <div class="placeholder wave h-16p">
                                <div class="square"></div>
                            </div>
                        </td>
                        <td>
                            <div class="placeholder wave h-16p">
                                <div class="square"></div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <div class="placeholder wave h-16p">
                                <div class="square"></div>
                            </div>
                        </td>
                        <td>
                            <div class="placeholder wave h-16p">
                                <div class="square"></div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <div class="placeholder wave h-16p">
                                <div class="square"></div>
                            </div>
                        </td>
                        <td>
                            <div class="placeholder wave h-16p">
                                <div class="square"></div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <div class="placeholder wave h-16p">
                                <div class="square"></div>
                            </div>
                        </td>
                        <td>
                            <div class="placeholder wave h-16p">
                                <div class="square"></div>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php /**PATH /home/creativedesignbd/ecommerce9.creativedesign.com.bd/resources/views/admin/dashboxes/most-sold-brands.blade.php ENDPATH**/ ?>