
<?php $__env->startSection('page_title', __('Order Statuses')); ?>
<?php $__env->startSection('css'); ?>
    
    <link rel="stylesheet" href="<?php echo e(asset('public/dist/plugins/Responsive-2.2.5/css/responsive.dataTables.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/dist/css/product.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Main content -->
    <div class="col-sm-12" id="order-status-container">
        <div class="card">
            <div class="card-body row">
                <div class="col-lg-3 ltr:ps-1 ltr:ps-lg-3 ltr:pe-0 rtl:pe-1 rtl:pe-lg-3 rtl:ps-0">
                    <?php echo $__env->make('admin.layouts.includes.order_settings_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="col-lg-9 ltr:ps-1 ltr:ps-lg-0 rtl:pe-1 rtl:pe-lg-0">
                    <div class="card card-info shadow-none mb-0">
                        <?php if(session('errorMgs')): ?>
                            <div class="alert alert-warning fade in alert-dismissable">
                                <strong><?php echo e(__('Warning')); ?>!</strong> <?php echo e(session('errorMgs')); ?>. <a class="close"
                                    href="#" data-bs-dismiss="alert" aria-label="close" title="close">×</a>
                            </div>
                        <?php endif; ?>
                        <div class="card-header p-t-20 border-bottom order-header" id="smtp_head">
                            <h5><?php echo e(__('Status')); ?></h5>
                            <?php if(in_array('App\Http\Controllers\OrderStatusController@store', $prms)): ?>
                                <div class="card-header-right">
                                    <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#add-status"
                                        class="btn btn-outline-primary custom-btn-small"><span class="fa fa-plus">
                                            &nbsp;</span><?php echo e(__('Add :x', ['x' => __('Status')])); ?></a>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="card-body p-2 p-md-4 product-table">
                            <div class="row">
                                <div class="table-responsive">
                                    <table id="dataTableBuilder" class="table table-hover table-striped dt-responsive">
                                        <thead>
                                            <tr>
                                                <th><?php echo e(__('Name')); ?></th>
                                                <th><?php echo e(__('Role')); ?></th>
                                                <th><?php echo e(__('Color')); ?></th>
                                                <th><?php echo e(__('Payment Scenario')); ?></th>
                                                <th><?php echo e(__('Order By')); ?></th>
                                                <th><?php echo e(__('Default')); ?></th>
                                                <?php if(array_intersect(
                                                        ['App\Http\Controllers\OrderStatusController@edit', 'App\Http\Controllers\OrderStatusController@destroy'],
                                                        $prms)): ?>
                                                    <th><?php echo e(__('Action')); ?></th>
                                                <?php endif; ?>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $orderStatuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($status->name); ?></td>
                                                    <td><?php echo $status->roleName($status->role); ?></td>
                                                    <td>
                                                        <div class="h-40" style="background: <?php echo e($status->color); ?>"></div>
                                                    </td>
                                                    <td><?php echo e($status->payment_scenario); ?></td>
                                                    <td><?php echo e($status->order_by); ?></td>
                                                    <td><?php echo e($status->is_default == 1 ? __('Yes') : __('No')); ?></td>
                                                    <?php if(array_intersect(
                                                            ['App\Http\Controllers\OrderStatusController@edit', 'App\Http\Controllers\OrderStatusController@destroy'],
                                                            $prms)): ?>
                                                        <td>
                                                            <?php if(in_array('App\Http\Controllers\OrderStatusController@edit', $prms)): ?>
                                                                <a title="<?php echo e(__('Edit')); ?>" href="javascript:void(0)"
                                                                    class="btn btn-xs btn-primary edit_status"
                                                                    data-bs-toggle="modal" data-bs-target="#edit-status"
                                                                    id="<?php echo e($status->id); ?>"><span
                                                                        class="feather icon-edit neg-transition-scale-svg "></span></a>
                                                                &nbsp;
                                                            <?php endif; ?>

                                                            <?php if(in_array('App\Http\Controllers\OrderStatusController@destroy', $prms) &&
                                                                    $status->is_default != 1 &&
                                                                    !in_array($status->slug, coreStatusSlug())): ?>
                                                                <form method="POST"
                                                                    action="<?php echo e(route('orderStatues.delete', $status->id)); ?>"
                                                                    accept-charset="UTF-8"
                                                                    id="delete-language-<?php echo e($status->id); ?>"
                                                                    class="display_inline">
                                                                    <?php echo csrf_field(); ?>
                                                                    <input type="hidden" name="id"
                                                                        value="<?php echo e($status->id); ?>">
                                                                    <button title="<?php echo e(__('Delete')); ?>"
                                                                        class="btn btn-xs btn-danger"
                                                                        data-id="<?php echo e($status->id); ?>" type="button"
                                                                        data-bs-toggle="modal"
                                                                        data-bs-target="#confirmDelete" data-label="Delete"
                                                                        data-title="<?php echo e(__('Delete :x', ['x' => __('Status')])); ?>"
                                                                        data-message="<?php echo e(__('Are you sure to delete this?')); ?>">
                                                                        <i class="feather icon-trash-2"></i>
                                                                    </button>
                                                                </form>
                                                            <?php endif; ?>
                                                        </td>
                                                    <?php endif; ?>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal fade" id="confirmDelete" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="confirmDeleteLabel"></h5>
                        <a type="button" class="close h5" data-bs-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </a>
                    </div>
                    <div class="modal-body">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="py-2 custom-btn-cancel"
                            data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                        <button type="button" id="confirmDeleteSubmitBtn" data-task=""
                            class="btn py-2 ltr:ms-2 rtl:me-2 custom-btn-submit"><?php echo e(__('Yes, Confirm')); ?></button>
                        <span class="ajax-loading"></span>
                    </div>
                </div>
            </div>
        </div>

        <div id="add-status" class="modal fade display_none" role="dialog">
            <div class="modal-dialog">

                <!-- Modal content-->
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title"><?php echo e(__('Add New')); ?> &nbsp; </h4>
                        <a type="button" class="close h5" data-bs-dismiss="modal">×</a>
                    </div>
                    <div class="modal-body">
                        <form action="<?php echo e(route('orderStatues.store')); ?>" method="post" id="addStatus"
                            class="form-horizontal">
                            <?php echo csrf_field(); ?>

                            <div class="form-group row">
                                <label class="col-sm-3 control-label require" for="inputEmail3"><?php echo e(__('Name')); ?></label>

                                <div class="col-sm-6">
                                    <input type="text" placeholder="<?php echo e(__('Name')); ?>" value="<?php echo e(old('name')); ?>"
                                        class="form-control name inputFieldDesign" name="name" required
                                        oninvalid="this.setCustomValidity('<?php echo e(__('This field is required.')); ?>')">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-sm-3 control-label require pr-0 "
                                    for="inputEmail3"><?php echo e(__('Role')); ?></label>
                                <div class="col-sm-6">
                                    <select class="form-control select2-hide-search sl_common_bx" name="role_ids[]"
                                        id="role_id" multiple required
                                        oninvalid="this.setCustomValidity('<?php echo e(__('This field is required.')); ?>')">
                                        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($role->id); ?>"
                                                <?php echo e(old('role_id') == $role->id ? 'selected' : ''); ?>><?php echo e($role->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-sm-3 control-label require"><?php echo e(__('Color')); ?></label>

                                <div class="col-sm-6">
                                    <input type="color" value="<?php echo e(old('color')); ?>" class="form-control"
                                        name="color">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-sm-3 control-label require"
                                    for="inputEmail3"><?php echo e(__('Order By')); ?></label>

                                <div class="col-sm-6">
                                    <input type="number" placeholder="<?php echo e(__('Order By')); ?>"
                                        value="<?php echo e(old('order_by')); ?>" class="form-control inputFieldDesign"
                                        name="order_by" required
                                        oninvalid="this.setCustomValidity('<?php echo e(__('This field is required.')); ?>')">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-sm-3 control-label require pr-0"
                                    for="payment_scenario"><?php echo e(__('Pay. Scenario')); ?></label>
                                <div class="col-sm-6">
                                    <select class="js-example-basic-single-1 form-control select2-hide-search sl_common_bx"
                                        name="payment_scenario" required
                                        oninvalid="this.setCustomValidity('<?php echo e(__('This field is required.')); ?>')">
                                        <option value="unpaid"
                                            <?php echo e(old('payment_scenario') == 'unpaid' ? 'selected' : ''); ?>>
                                            <?php echo e(__('Unpaid')); ?></option>
                                        <option value="paid" <?php echo e(old('payment_scenario') == 'paid' ? 'selected' : ''); ?>>
                                            <?php echo e(__('Paid')); ?></option>
                                    </select>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-sm-3 control-label require pr-0"
                                    for="is_default"><?php echo e(__('Default')); ?></label>
                                <div class="col-sm-6">
                                    <select class="js-example-basic-single-1 form-control select2-hide-search sl_common_bx"
                                        name="is_default" required
                                        oninvalid="this.setCustomValidity('<?php echo e(__('This field is required.')); ?>')">
                                        <option value="0" <?php echo e(old('is_default') == '0' ? 'selected' : ''); ?>>
                                            <?php echo e(__('No')); ?></option>
                                        <option value="1" <?php echo e(old('is_default') == '1' ? 'selected' : ''); ?>>
                                            <?php echo e(__('Yes')); ?></option>
                                    </select>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="btn_save" class="col-sm-3 control-label"></label>
                                <div class="col-sm-12">
                                    <button type="submit"
                                        class="btn py-2 custom-btn-submit ltr:float-right rtl:float-left"><?php echo e(__('Create')); ?></button>
                                    <button type="button"
                                        class="py-2 custom-btn-cancel ltr:float-right ltr:me-2 rtl:float-left rtl:ms-2"
                                        data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div id="edit-status" class="modal fade display_none" role="dialog">
            <div class="modal-dialog">

                <!-- Modal content-->
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title"><?php echo e(__('Edit :x', ['x' => __('Status')])); ?> &nbsp;</h4>
                        <a type="button" class="close h5" data-bs-dismiss="modal">×</a>
                    </div>
                    <div class="modal-body">
                        <form action="<?php echo e(route('orderStatues.update')); ?>" method="post" id="editTax"
                            class="form-horizontal">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="status_id" id="status_id">
                            <div class="form-group row">
                                <label class="col-sm-3 control-label require"
                                    for="status_name"><?php echo e(__('Name')); ?></label>

                                <div class="col-sm-6">
                                    <input type="text" class="form-control inputFieldDesign"
                                        placeholder="<?php echo e(__('Name')); ?>" id="status_name" name="name" required
                                        oninvalid="this.setCustomValidity('<?php echo e(__('This field is required.')); ?>')">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-sm-3 control-label require"
                                    for="inputEmail3"><?php echo e(__('Order By')); ?></label>

                                <div class="col-sm-6">
                                    <input type="number" placeholder="<?php echo e(__('Order By')); ?>"
                                        value="<?php echo e(old('order_by')); ?>" class="form-control inputFieldDesign"
                                        name="order_by" id="status_orderBy" required
                                        oninvalid="this.setCustomValidity('<?php echo e(__('This field is required.')); ?>')">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-sm-3 control-label require pr-0"
                                    for="role_id"><?php echo e(__('Role')); ?></label>
                                <div class="col-sm-6">
                                    <select class="form-control select2-hide-search sl_common_bx" name="role_ids[]"
                                        id="status_role_id" multiple required
                                        oninvalid="this.setCustomValidity('<?php echo e(__('This field is required.')); ?>')">
                                        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($role->id); ?>"><?php echo e($role->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-sm-3 control-label require"><?php echo e(__('Color')); ?></label>

                                <div class="col-sm-6">
                                    <input type="color" value="<?php echo e(old('color')); ?>" class="form-control"
                                        name="color" id="status_color">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-sm-3 control-label require pr-0"
                                    for="payment_scenario"><?php echo e(__('Pay. Scenario')); ?></label>
                                <div class="col-sm-6">
                                    <select class="js-example-basic-single-1 form-control select2-hide-search sl_common_bx"
                                        name="payment_scenario" id="payment_scenario" required
                                        oninvalid="this.setCustomValidity('<?php echo e(__('This field is required.')); ?>')">
                                        <option value="unpaid"><?php echo e(__('Unpaid')); ?></option>
                                        <option value="paid"><?php echo e(__('Paid')); ?></option>
                                    </select>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-sm-3 control-label require pr-0"
                                    for="status_is_default"><?php echo e(__('Default')); ?></label>
                                <div class="col-sm-6">
                                    <select class="js-example-basic-single-2 form-control select2-hide-search"
                                        name="is_default" id="status_is_default">
                                        <option value="0"><?php echo e(__('No')); ?></option>
                                        <option value="1"><?php echo e(__('Yes')); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="btn_save" class="col-sm-3 control-label"></label>
                                <div class="col-sm-12">
                                    <button type="submit"
                                        class="btn py-2 custom-btn-submit ltr:float-right rtl:float-left"><?php echo e(__('Update')); ?></button>
                                    <button type="button"
                                        class="py-2 custom-btn-cancel ltr:float-right ltr:me-2 rtl:float-left rtl:ms-2"
                                        data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('public/dist/plugins/DataTables-1.10.21/js/jquery.dataTablesCus.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/plugins/Responsive-2.2.5/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/js/custom/order_status.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/js/custom/validation.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/creativedesignbd/ecommerce9.creativedesign.com.bd/resources/views/admin/order_status/index.blade.php ENDPATH**/ ?>