
<?php $__env->startSection('page_title', __('Languages')); ?>
<?php $__env->startSection('css'); ?>
    
    <link rel="stylesheet" href="<?php echo e(asset('public/dist/plugins/Responsive-2.2.5/css/responsive.dataTables.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/dist/css/product.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Main content -->
    <div class="col-sm-12" id="language-settings-container">
        <div class="card">
            <div class="card-body row">
                <div
                    class="col-lg-3 col-12 z-index-10 ltr:ps-md-3 ltr:pe-0 ltr:ps-0 rtl:pe-md-3 rtl:ps-0 rtl:pe-0">
                    <?php echo $__env->make('admin.layouts.includes.general_settings_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="col-lg-9 col-12 ltr:ps-0 rtl:pe-0">
                    <div class="card card-info shadow-none mb-0">
                        <?php if(session('errorMgs')): ?>
                            <div class="alert alert-warning fade in alert-dismissable">
                                <strong><?php echo e(__('Warning')); ?>!</strong> <?php echo e(session('errorMgs')); ?>. <a class="close"
                                    href="#" data-bs-dismiss="alert" aria-label="close" title="close">×</a>
                            </div>
                        <?php endif; ?>

                        <div class="card-header p-t-20 border-bottom d-inline-block" id="smtp_head">
                            <h5><?php echo e(__('Languages')); ?></h5>
                            <?php if(in_array('App\Http\Controllers\LanguageController@store', $prms)): ?>
                                <div class="card-header-right language-header">
                                    <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#add-language"
                                        class="btn btn-outline-primary custom-btn-small m-0 ltr:me-2 rtl:ms-2"><span
                                            class="fa fa-plus">
                                            &nbsp;</span><?php echo e(__('Add Language')); ?></a>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="card-body px-2 px-md-4 product-table">
                            <div class="row p-l-15">
                                <div class="table-responsive">
                                    <table id="dataTableBuilder" class="table table-hover table-striped dt-responsive">
                                        <thead>
                                            <tr>
                                                <th><?php echo e(__('Language Name')); ?></th>
                                                <th><?php echo e(__('Short Name')); ?></th>
                                                <th><?php echo e(__('Flag')); ?></th>
                                                <th><?php echo e(__('Status')); ?></th>
                                                <?php if(array_intersect(
                                                        [
                                                            'App\Http\Controllers\LanguageController@translation',
                                                            'App\Http\Controllers\LanguageController@edit',
                                                            'App\Http\Controllers\LanguageController@delete',
                                                        ],
                                                        $prms)): ?>
                                                    <th><?php echo e(__('Action')); ?></th>
                                                <?php endif; ?>

                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $languageList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($language->name); ?></td>
                                                    <td><?php echo e($language->short_name); ?></td>
                                                    <td>
                                                        <img src='<?php echo e(url('public/datta-able/fonts/flag/flags/4x3/' . getSVGFlag($language->short_name) . '.svg')); ?>'
                                                            width="32">
                                                    </td>
                                                    <td>
                                                        <?php
                                                            $color = $language->status == 'Active' ? 'active_color' : 'inactive_color';
                                                        ?>
                                                        <span
                                                            class="badge f-12 active_inactive_checking <?php echo e($color); ?>"><?php echo e($language->status); ?></span>
                                                    </td>
                                                    <?php if(array_intersect(
                                                            [
                                                                'App\Http\Controllers\LanguageController@translation',
                                                                'App\Http\Controllers\LanguageController@edit',
                                                                'App\Http\Controllers\LanguageController@delete',
                                                            ],
                                                            $prms)): ?>
                                                        <td>
                                                            <?php if(in_array('App\Http\Controllers\LanguageController@translation', $prms)): ?>
                                                                <a title="<?php echo e(__('Translate language')); ?>"
                                                                    href="<?php echo e(route('language.translation', $language->id)); ?>"
                                                                    class="btn btn-xs btn-secondary"><span
                                                                        class="fas fa-language"></span></a> &nbsp;
                                                            <?php endif; ?>

                                                            <?php if(in_array('App\Http\Controllers\LanguageController@edit', $prms)): ?>
                                                                <a title="<?php echo e(__('Edit language')); ?>"
                                                                    href="javascript:void(0)"
                                                                    class="btn btn-xs btn-primary edit_language"
                                                                    data-bs-toggle="modal" data-bs-target="#edit_language"
                                                                    id="<?php echo e($language->id); ?>"><span
                                                                        class="feather icon-edit neg-transition-scale-svg "></span></a>
                                                                &nbsp;
                                                            <?php endif; ?>

                                                            <?php if(in_array('App\Http\Controllers\LanguageController@delete', $prms) &&
                                                                    $language->is_default != 1 &&
                                                                    $language->short_name != 'en'): ?>
                                                                <form method="POST"
                                                                    action="<?php echo e(route('language.delete', $language->id)); ?>"
                                                                    accept-charset="UTF-8"
                                                                    id="delete-language-<?php echo e($language->id); ?>"
                                                                    class="display_inline">
                                                                    <?php echo csrf_field(); ?>

                                                                    <input type="hidden" name="flag"
                                                                        value="<?php echo e($language->flag); ?>">
                                                                    <input type="hidden" name="id"
                                                                        value="<?php echo e($language->id); ?>">
                                                                    <button title="<?php echo e(__('Delete')); ?>"
                                                                        class="btn btn-xs btn-danger"
                                                                        data-id="<?php echo e($language->id); ?>" type="button"
                                                                        data-bs-toggle="modal"
                                                                        data-bs-target="#confirmDelete" data-label="Delete"
                                                                        data-title="<?php echo e(__('Delete Language')); ?>"
                                                                        data-message="<?php echo e(__('Are you sure to delete this language?')); ?>">
                                                                        <i class="feather icon-trash-2"></i>
                                                                    </button>
                                                                </form>
                                                            <?php endif; ?>
                                                        </td>
                                                    <?php endif; ?>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal fade" id="confirmDelete" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="confirmDeleteLabel"></h5>
                        <a type="button" class="close h5" data-bs-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </a>
                    </div>
                    <div class="modal-body">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="py-2 custom-btn-cancel"
                            data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                        <button type="submit" id="confirmDeleteSubmitBtn" data-bs-task=""
                            class="btn py-2 custom-btn-submit"><?php echo e(__('Yes, Confirm')); ?>

                            <span class="ajax-loading"></span>
                    </div>
                </div>
            </div>
        </div>
        <div id="add-language" class="modal fade display_none" role="dialog">
            <div class="modal-dialog">
                <!-- Modal content-->
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title"><?php echo e(__('Add New')); ?></h4>
                        <a type="button" class="close h5" data-bs-dismiss="modal">×</a>
                    </div>
                    <form action="<?php echo e(route('language.store')); ?>" method="post" id="addLanguage"
                        class="form-horizontal" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>

                        <div class="modal-body">
                            <div class="form-group row">
                                <label class="col-sm-4 control-label require"
                                    for="language_name"><?php echo e(__('Language Name')); ?></label>
                                <div class="col-sm-7">
                                    <select class="form-control js-example-basic-single-2 sl_common_bx" id="language_name"
                                        name="language_name" required
                                        oninvalid="this.setCustomValidity('<?php echo e(__('This field is required.')); ?>')">
                                        <option value=""><?php echo e(__('Select One')); ?></option>
                                        <?php $__currentLoopData = $languageShortName; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>

                            <div class="form-group row sl_status">
                                <label class="col-sm-4 control-label require" for="status"><?php echo e(__('Status')); ?></label>
                                <div class="col-sm-7">
                                    <select class="form-control js-example-basic-single-2 sl_common_bx" id="status"
                                        name="status" required
                                        oninvalid="this.setCustomValidity('<?php echo e(__('This field is required.')); ?>')">
                                        <option value=""><?php echo e(__('Select One')); ?></option>
                                        <option value="Active"><?php echo e(__('Active')); ?></option>
                                        <option value="Inactive"><?php echo e(__('Inactive')); ?></option>
                                    </select>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-sm-4 control-label require"
                                    for="direction"><?php echo e(__('Website Direction')); ?></label>
                                <div class="col-sm-7">
                                    <select class="form-control js-example-basic-single-2 sl_common_bx" id="direction"
                                        name="direction" required
                                        oninvalid="this.setCustomValidity('<?php echo e(__('This field is required.')); ?>')">
                                        <option value=""><?php echo e(__('Select One')); ?></option>
                                        <option value="ltr"><?php echo e(__('Left to Right')); ?></option>
                                        <option value="rtl"><?php echo e(__('Right to Left')); ?></option>
                                    </select>
                                    <small class="text-info"><?php echo e(__('Applied only for this panel')); ?>&nbsp;</small>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-4 control-label" for="default"><?php echo e(__('Is Default')); ?></label>
                                <div class="col-sm-0 switch switch-primary">
                                    <input class="switch switch-primary minimal" type="checkbox" id="default"
                                        name="default">
                                    <label for="default" class="cr ml-3 swicth-pos"></label>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer py-0">
                            <div class="form-group row">
                                <label for="btn_save" class="col-sm-3 control-label"></label>
                                <div class="col-sm-12">
                                    <button type="submit"
                                        class="py-2 btn custom-btn-submit ltr:float-right rtl:float-left"><?php echo e(__('Create')); ?></button>
                                    <button type="button"
                                        class="py-2 custom-btn-cancel ltr:float-right ltr:me-2 rtl:float-left rtl:ms-2"
                                        data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>

            </div>
        </div>

        <div id="edit_language" class="modal fade display_none" role="dialog">
            <div class="modal-dialog">
                <!-- Modal content-->
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title"><?php echo e(__('Edit Language')); ?></h4>
                        <a type="button" class="close h5" data-bs-dismiss="modal">×</a>
                    </div>
                    <form action="<?php echo e(route('language.update')); ?>" method="post" id="editLanguage"
                        class="form-horizontal" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>

                        <div class="modal-body">
                            <div class="form-group row">
                                <label class="col-sm-4 control-label require"
                                    for="edit_status"><?php echo e(__('Status')); ?></label>
                                <div class="col-sm-7">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <select class="form-control js-example-basic-single-1 sl_common_bx"
                                                id="edit_status" name="edit_status" required
                                                oninvalid="this.setCustomValidity('<?php echo e(__('This field is required.')); ?>')">
                                                <option value=""><?php echo e(__('Select One')); ?></option>
                                                <option value="Active"><?php echo e(__('Active')); ?></option>
                                                <option value="Inactive"><?php echo e(__('Inactive')); ?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-sm-4 control-label require"
                                    for="edit_direction"><?php echo e(__('Website Direction')); ?></label>
                                <div class="col-sm-7">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <select class="form-control js-example-basic-single-1 sl_common_bx"
                                                id="edit_direction" name="edit_direction" required
                                                oninvalid="this.setCustomValidity('<?php echo e(__('This field is required.')); ?>')">
                                                <option value=""><?php echo e(__('Select One')); ?></option>
                                                <option value="ltr"><?php echo e(__('Left to Right')); ?></option>
                                                <option value="rtl"><?php echo e(__('Right to Left')); ?></option>
                                            </select>
                                            <small class="text-info"><?php echo e(__('Applied only for this panel')); ?>&nbsp;</small>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-sm-4 control-label require" for="edit_flag"><?php echo e(__('Flag')); ?></label>
                                <div class="col-sm-7">
                                    <img id="editImg" src='#' alt="<?php echo e(__('Image')); ?>"
                                        class="img-responsive img-thumbnail" height="64" width="64" />
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-sm-4 control-label" for="edit_default"><?php echo e(__('Is Default')); ?></label>
                                <div class="col-sm-0 switch switch-primary">
                                    <input class="switch switch-primary minimal" type="checkbox" id="edit_default"
                                        name="edit_default">
                                    <label for="edit_default" class="cr ml-3 swicth-pos"></label>
                                </div>
                            </div>

                            <input type="hidden" name="language_id" id="language_id">
                        </div>
                        <div class="modal-footer py-0">
                            <div class="form-group row">
                                <label for="btn_save" class="col-sm-3 control-label"></label>
                                <div class="col-sm-12">
                                    <button type="submit"
                                        class="py-2 btn custom-btn-submit ltr:float-right rtl:float-left"><?php echo e(__('Update')); ?></button>
                                    <button type="button"
                                        class="py-2 custom-btn-cancel ltr:float-right ltr:me-2 rtl:float-left rtl:ms-2"
                                        data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('public/dist/plugins/DataTables-1.10.21/js/jquery.dataTablesCus.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/plugins/Responsive-2.2.5/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/js/custom/common.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/js/custom/settings.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/js/custom/validation.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/creativedesignbd/ecommerce9.creativedesign.com.bd/resources/views/admin/language/index.blade.php ENDPATH**/ ?>