<?php
    $seoTitle = isset($seo['title']) && strlen($seo['title']) > 0 ? $seo['title'] : $name;
    $seoDescription = isset($seo['description']) && strlen($seo['description']) > 0 ? $seo['description'] : $summary;
    $seoImage = '';
    if (isset($seo['image']) && strlen($seo['image']) && !is_array($seo['image'])) {
        $seoImage = $seo['image'];
    } else if (is_array($images) && count($images)) {
       $seoImage = reset($images);
    }
?>
<meta name="robots" content="index, follow">
<meta name="description" content="<?php echo e($seoDescription); ?>" />
<meta name="keywords" content="">
<!-- Schema.org markup for Google+ -->
<meta itemprop="name" content="<?php echo e($seoTitle); ?>">
<meta itemprop="description" content="<?php echo e($seoDescription); ?>">
<meta itemprop="image" content="<?php echo e($seoImage); ?>">

<!-- Twitter Card data -->
<meta name="twitter:card" content="<?php echo e(__('Product')); ?>">
<meta name="twitter:site" content="@publisher_handle">
<meta name="twitter:title" content="<?php echo e($seoTitle); ?>">
<meta name="twitter:description" content="<?php echo e($seoDescription); ?>">
<meta name="twitter:creator" content="@author_handle">
<meta name="twitter:image" content="<?php echo e($seoImage); ?>">
<meta name="twitter:data1" content="">
<meta name="twitter:label1" content="<?php echo e(__('Price')); ?>">

<!-- Open Graph data -->
<meta property="og:title" content="<?php echo e($seoTitle); ?>" />
<meta property="og:type" content="og:<?php echo e(__('Product')); ?>" />
<meta property="og:url" content="<?php echo e(route('site.productDetails', ['slug' => $slug])); ?>" />
<meta property="og:image" content="<?php echo e($seoImage); ?>" />
<meta property="og:description" content="<?php echo e($seoDescription); ?>" />
<meta property="og:site_name" content="<?php echo e(trimWords(preference('company_name'), 17)); ?>" />
<meta property="og:price:amount" content="" />
<meta property="product:price:currency" content="<?php echo e(currency()->name); ?>" />
<meta property="fb:app_id" content="">
<?php /**PATH /home/creativedesignbd/ecommerce9.creativedesign.com.bd/resources/views/site/layouts/section/product-details/seo.blade.php ENDPATH**/ ?>