
<?php $__env->startSection('page_title'); ?>
    <?php if(isset($product)): ?>
        <?php echo e($product->name); ?> - <?php echo e(__('Edit :x', ['x' => __('Product')])); ?>

    <?php else: ?>
        <?php echo e(__('Create new item')); ?>

    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <!-- summer note css -->
    <link rel="stylesheet" href="<?php echo e(asset('public/datta-able/plugins/summer-note/summernote-lite.min.css')); ?>">
    <!-- custom category -->
    <link rel="stylesheet" href="<?php echo e(asset('public/dist/css/custom-category.min.css')); ?>">
    <!-- date range picker css -->
    <link rel="stylesheet" href="<?php echo e(asset('public/dist/plugins/bootstrap-daterangepicker/daterangepicker.min.css')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <?php
        $isAdmin = true;
        $productForSelector = isset($product) ? $product : null;
    ?>
    <!-- Main content -->
    <div class="col-md-12 no-print notification-msg-bar smoothly-hide">
        <div class="noti-alert pad">
            <div class="alert bg-dark text-light m-0 text-center">
                <span class="notification-msg"></span>
            </div>
        </div>
    </div>

    <?php
        $sections = (new \App\Services\Product\Editor\Section($productForSelector))->getSections()['sections'];
    ?>

    <div class="col-md-12 overflow-x-hidden list-container" id="invoice-view-container">
        <div class="row">
            <?php echo csrf_field(); ?>
            <div class="col-md-12 col-lg-12 col-xl-9 order-last order-xl-first">
                <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name => $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(
                        ($section['visibility'] ?? '1') == '1' &&
                            !($section['is_left_side'] ?? false) &&
                            ($section['is_main'] ?? false) &&
                            !($section['is_draggable'] ?? false)): ?>
                        <?php if(is_callable($section['content'])): ?>
                            <?php echo $section['content'](); ?>

                        <?php else: ?>
                            <?php if ($__env->exists($section['content'])) echo $__env->make($section['content'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <div id="sortable" class="drag_and_drop">
                    <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name => $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(
                            ($section['visibility'] ?? '1') == '1' &&
                                !($section['is_left_side'] ?? false) &&
                                ($section['is_main'] ?? false) &&
                                ($section['is_draggable'] ?? false)): ?>
                            <?php if(is_callable($section['content'])): ?>
                                <?php echo $section['content'](); ?>

                            <?php else: ?>
                                <?php if ($__env->exists($section['content'])) echo $__env->make($section['content'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php endif; ?>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>

            <div class="col-md-12 col-lg-12 col-xl-3">
                <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name => $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(($section['visibility'] ?? '1') != '1' || ($section['is_main'] ?? false)): ?>
                        <?php continue; ?>
                    <?php endif; ?>

                    <?php if($section['is_left_side'] ?? false): ?>
                        <?php if(is_callable($section['content'])): ?>
                            <?php echo $section['content'](); ?>

                        <?php else: ?>
                            <?php if ($__env->exists($section['content'])) echo $__env->make($section['content'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>

    <form
        action="<?php echo e(isset($product) ? route('products.edit-action', ['code' => $product->code]) : route('product.create')); ?>"
        method="post" id="ajaxReloadForm">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="action" class="ajax-form-action">
        <input type="hidden" name="data" class="ajax-form-data">
    </form>

    <div class="modal fade" id="confirmDelete" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="confirmDeleteLabel"></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn custom-btn-cancel all-cancel-btn"
                        data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                    <button type="button" id="confirmDeleteSubmitBtn" data-bs-dismiss="modal" data-task=""
                        class="btn custom-btn-submit"><?php echo e(__('Yes, Confirm')); ?></button>
                    <span class="ajax-loading"></span>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('admin.products.sections.sub.attribute-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('mediamanager::image.modal_image', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php
        $parentCategory = null;
        $parentCategoryId = null;
    ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <!-- Jquery Ui JS -->
    <script src="<?php echo e(asset('public/dist/plugins/jQueryUI/jquery-ui.min.js')); ?>"></script>
    <!-- sweetalert JS -->
    <script src="<?php echo e(asset('public/datta-able/plugins/sweetalert/js/sweetalert.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/js/custom/delete-modal.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/js/custom/product.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/js/custom/jquery.blockUI.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/js/custom/custom-category.min.js')); ?>"></script>
    <script>
        var parentCategoryId = <?php echo e(isset($product) ? json_encode($parentCategoryId) : json_encode([])); ?>

        parentCategoryId != '' ? buttonIsDisable = false : '';
        loadListProduct(false);
        var confirmTextCurrentSection = '';
    </script>
    <?php if(!empty($parentCategory)): ?>
        <?php $__currentLoopData = explode(' / ', $parentCategory); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $parent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <script>
                confirmTextCurrentSection +=
                    `<li class="breadcrumb-item" data-catId = <?php echo e($parentCategoryId[$key] ?? null); ?>><a class="custom-a" href="javascript:void(0)"><?php echo e($parent); ?></a></li>`;
            </script>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
    <script>
        let itemUrl =
            '<?php echo e(isset($product) ? route('products.edit-action', ['code' => $product->code]) : route('product.create')); ?>';
        let itemsAjaxSearch =
            '<?php echo e(isset($product) ? route('findProductsAjax', ['code' => $product->code]) : route('findProductsAjax')); ?>';
        let tagsAjaxSearch = '<?php echo e(route('findTagsAjax')); ?>';
        let variationImagePlaceholder = '<?php echo e(asset('public/dist/img/not.svg')); ?>';
        const countHelper = {
            attributes: 0,
            variations: 0
        }
        var videoExtensions = <?php echo json_encode(getFileExtensions(6), 15, 512) ?>;
    </script>

    <script src="<?php echo e(asset('public/dist/js/xss.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/js/custom/create-product.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/js/moment.min.js')); ?>"></script>
    <!-- date range picker Js -->
    <script src="<?php echo e(asset('public/dist/plugins/bootstrap-daterangepicker/daterangepicker.min.js')); ?>"></script>
    <!-- summernote JS -->
    <script src="<?php echo e(asset('public/datta-able/plugins/summer-note/summernote-lite.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/creativedesignbd/ecommerce9.creativedesign.com.bd/resources/views/admin/products/product.blade.php ENDPATH**/ ?>