@if (isActive('Newsletter'))
    <section class="primary-bg-color py-3.5 relative pb-22p px-5 sub-img my-10 md:my-12"
        style='background-image:url({{ asset('public/frontend/assets/img/product/bg-img.png') }});margin-top:{{ $component->mt }};margin-bottom:{{ $component->mb }};'>
        <div class="text-black flex flex-col items-center justify-center py-4 md:pt-8 md:pb-6">
            @if ($component->title)
                <p class="font-bold text-center md:text-3xl text-2xl dm-bold px-2">
                    {!! $component->title !!}
                </p>
            @endif
            <p class="mb-4 text-center font-medium text-base roboto-medium text-gray-12 mt-2">
                @if ($component->message)
                    {!! chunk_split($component->message, 71, '<br>') !!}
                @endif
            </p>

            <div>
                <form action="{{ route('subscriber.store') }}" method="post" id="subscribe">
                    @csrf
                    <div
                        class="flex items-center relative rounded input-width search-border mt-1.5 bg-white search-placeholder">
                        <input
                            class="bg-transparent border-0 h-11 x:w-72 md:h-50p md:w-532p w-337p text-sm focus:outline-none px-14"
                            type="text" name="email" placeholder="{{ __('Type your email address') }}"
                            value="{{ old('email') }}" />
                        <button type="submit"
                            class="absolute left-0 ml-3.5 pr-2 border-r border-gray-300 h-6 search-btn">
                            <svg class="h-5 w-5 md:h-6 md:w-6 fill-current text-gray-500" width="26" height="26"
                                viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M22.4621 3.50497C21.806 3.62167 20.8759 3.92693 19.3866 4.42337L8.14797 8.16956C6.71541 8.64708 5.70467 8.98456 4.97764 9.26822C4.61808 9.40851 4.36766 9.52058 4.19353 9.61245C4.04604 9.69026 3.99302 9.73312 3.98987 9.73531C3.28715 10.4156 3.28715 11.5428 3.98986 12.2231C3.99302 12.2253 4.04604 12.2682 4.19353 12.346C4.36766 12.4378 4.61808 12.5499 4.97764 12.6902C5.70467 12.9739 6.71541 13.3113 8.14797 13.7889C8.18085 13.7998 8.21347 13.8107 8.24581 13.8214C8.71913 13.9789 9.13471 14.1171 9.51728 14.3194C10.4392 14.807 11.193 15.5608 11.6806 16.4827C11.8829 16.8653 12.0212 17.2809 12.1786 17.7542C12.1893 17.7866 12.2002 17.8192 12.2111 17.852C12.6887 19.2846 13.0261 20.2953 13.3098 21.0224C13.4501 21.3819 13.5622 21.6323 13.654 21.8065C13.7318 21.954 13.7747 22.007 13.7769 22.0101C14.4572 22.7128 15.5844 22.7128 16.2647 22.0101C16.2669 22.007 16.3097 21.954 16.3876 21.8065C16.4794 21.6323 16.5915 21.3819 16.7318 21.0224C17.0154 20.2953 17.3529 19.2846 17.8304 17.852L21.5766 6.61345C22.0731 5.12413 22.3783 4.19397 22.495 3.53793C22.4975 3.52428 22.4998 3.51099 22.5019 3.49806C22.489 3.50024 22.4757 3.50254 22.4621 3.50497ZM22.9104 3.46495C22.9101 3.46526 22.9044 3.4648 22.8944 3.4626C22.9058 3.46353 22.9108 3.46463 22.9104 3.46495ZM22.5374 3.10553C22.5352 3.09559 22.5347 3.08991 22.5351 3.08955C22.5354 3.08919 22.5365 3.09415 22.5374 3.10553ZM21.8556 0.0956598C22.8096 -0.0740486 24.1159 -0.124584 25.1203 0.879735C26.1246 1.88405 26.074 3.19042 25.9043 4.14442C25.7376 5.08186 25.3455 6.2577 24.9031 7.58446L24.8618 7.7085L21.1156 18.9471L21.0993 18.9959C20.6417 20.3687 20.277 21.4628 19.9578 22.281C19.6577 23.0501 19.3019 23.8472 18.7661 24.4048C16.7222 26.5317 13.3194 26.5317 11.2755 24.4048C10.7397 23.8472 10.3839 23.0501 10.0838 22.281C9.76461 21.4629 9.39991 20.3688 8.94237 18.9961L8.92602 18.9471C8.71756 18.3217 8.67061 18.1983 8.6195 18.1016C8.45697 17.7943 8.2057 17.543 7.89839 17.3805C7.80174 17.3294 7.67831 17.2824 7.05292 17.074L7.00387 17.0576C5.63123 16.6001 4.53713 16.2354 3.71896 15.9162C2.9499 15.6161 2.15281 15.2603 1.59521 14.7245C-0.531735 12.6806 -0.531735 9.27782 1.59521 7.23393C2.15281 6.6981 2.9499 6.34231 3.71897 6.04224C4.53716 5.72301 5.63131 5.3583 7.00402 4.90073L7.05293 4.88443L18.2915 1.13824C18.333 1.12441 18.3743 1.11063 18.4155 1.0969C19.7423 0.654498 20.9181 0.262424 21.8556 0.0956598Z"
                                    fill="#2C2C2C" />
                            </svg>
                        </button>

                        <button type="submit"
                            class="absolute text-base md:text-lg font-bold right-0 ml-3 pr-3.5 search-btn dm-bold">
                            <p class="send-btn custom-bottom-border">{{ __('Send') }}</p>
                            <svg role="status"
                                class="hidden ml-4 w-5 h-5 text-gray-200 animate-spin dark:text-gray-600 subscribe-loader"
                                viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z"
                                    fill="currentColor" />
                                <path
                                    d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z"
                                    fill="#00f" />
                            </svg>
                        </button>
                    </div>
                </form>
            </div>
            <div class="subscribe-message font-bold h-1">

            </div>
        </div>
    </section>
@endif
