<div class="form-group row">
    <label class="col-sm-3 pt-3 pt-md-2 control-label text-left require" for="bulk_pay_count"><?php echo e(__('Bulk Pay Count')); ?></label>
    <div class="col-sm-6">
        <div class="mr-3">
                <input class="form-control inputFieldDesign" id="bulk_pay_count" type="text" name="bulk_pay_count" value="<?php echo e(!is_null(preference('bulk_pay_count')) ? preference('bulk_pay_count') : ''); ?>" required oninvalid="this.setCustomValidity('<?php echo e(__('This field is required.')); ?>')">
        </div>
        
        <span class="help-block"><?php echo e(__('It will be measured how many order will payable at a time.')); ?></span>
    </div>
</div>
<?php
$paymentMethod = (new Modules\Gateway\Entities\GatewayModule)->payableGateways();
$preferenceBulkPayment = json_decode(preference('disable_bulk_payment'), true) ?? [];
$accessUserRole = json_decode(preference('bulk_payment_user_role'), true) ?? [];
$roles = \App\Models\Role::getAll();
?>
<div class="form-group row">
    <label class="col-sm-3 control-label text-left" for="disable_bulk_payment"><?php echo e(__('Disable bulk order payment method')); ?></label>
    <div class="col-sm-6 form-group flex-wrap">
        <input type="hidden" name="disable_bulk_payment" value="<?php echo e(null); ?>">
        <select class="form-control js-example-basic-single form-height sl_common_bx select2" name="disable_bulk_payment[]" id="disable_bulk_payment" multiple>
            <?php $__currentLoopData = $paymentMethod; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
                <option value="<?php echo e($method->alias); ?>" <?php echo e(in_array($method->alias, $preferenceBulkPayment) ? 'selected' : ''); ?>><?php echo e($method->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
</div>

<div class="form-group row">
    <label class="col-sm-3 control-label text-left" for="bulk_payment_user"><?php echo e(__('Access user role for bulk order payment')); ?></label>
    <div class="col-sm-6 form-group flex-wrap">
        <input type="hidden" name="bulk_payment_user_role" value="<?php echo e(null); ?>">
        <select class="form-control js-example-basic-single form-height sl_common_bx select2" name="bulk_payment_user_role[]" id="bulk_payment_user_role" multiple>
            <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($role->id); ?>" <?php if(in_array($role->id, $accessUserRole)): echo 'selected'; endif; ?>><?php echo e($role->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
</div>
<?php /**PATH /home/creativedesignbd/ecommerce9.creativedesign.com.bd/Modules/BulkPayment/Resources/views/layouts/settings.blade.php ENDPATH**/ ?>