<div id="item-edit-container">
    <div id="home" class="card section">
        <div class="card-h pt-24p pl-3-res">
            <h4> <a class="text-dark" href="<?php echo e(str_contains(url()->current(), '/admin') ? route('product.index') : route('vendor.products')); ?>"><?php echo e(__('Product')); ?> </a> /
                <span
                    class="f-13"><?php echo e(isset($product) ? __('Edit :x', ['x' => __('Product')]) : __('Create :x', ['x' => __('Product')])); ?></span>
            </h4>
        </div>
        <div class="table-border-style blockable pb-11p">
            <div class="row form-tabs pb-20-res">
                <div class="col-md-12 mt-7p" id="myTabContent">
                    <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                        <div class="row">
                            <div class="col-md-12 p-1">
                                <div class="card-border">
                                    <div class="card-body px-3-res px-32p">
                                        <div class="form-group row">
                                            <label for="name"
                                                class="label-title col-md-2 control-label"><?php echo e(__('Name')); ?>

                                            </label>
                                            <div class="col-md-10">
                                                <input type="text" placeholder="<?php echo e(__('Name')); ?>"
                                                    class="form-control inputFieldDesign" id="item_name" name="name"
                                                    value="<?php echo e(isset($product) ? $product->name : ''); ?>">
                                                <div
                                                    class="align-items-center mt-12p permalink-section close-parent <?php echo isset($product) ? ' d-md-flex flex-wrap ' : 'd-none'; ?>">
                                                    <span class="color-2c"><?php echo e(__('Permalink')); ?>:</span>
                                                    <a class="m-change ltr:ms-1 rtl:me-1 preview-link word-break" target="_blank"
                                                        href="<?php echo e(isset($product) ? route('site.productDetails', ['slug' => $product->slug]) : ''); ?>"
                                                        data-url="<?php echo e(url('/products')); ?>"><?php echo e(url('/products')); ?>/<span
                                                            class="permalink-msg"></span>
                                                    </a>
                                                    <input
                                                        class="border-0 edit-input bg-white edit-permalink customs-permalink d-none"
                                                        type="text" disabled
                                                        value="<?php echo e(isset($product) ? $product->slug : ''); ?>" />
                                                    <a
                                                        class="options-add px-2 t-10-res ltr:ms-1 rtl:me-1 f-12 edit-button bg-white">
                                                        <?php echo e(__('Edit')); ?>

                                                    </a>
                                                    <a
                                                        class="btn-add save-button save-permalink"><?php echo e(__('Ok')); ?></a>
                                                    <a
                                                        class="cancel-button f-14 font-weight-500 color-2c ltr:ms-2 rtl:me-2 cursor-pointer border-b-2c"><?php echo e(__('Cancel')); ?></a>
                                                </div>
                                            </div>
                                        </div>
                                        <?php if(count($categories)): ?>
                                            <div class="ajax-loader">
                                                <img src="<?php echo e(asset('public/dist/img/loader/loader.gif')); ?>"
                                                    class="img-responsive" />
                                            </div>
                                            <?php
                                                $catId = 0;
                                                $specificCat = 0;
                                                $specificSubCat = 1;
                                            ?>
                                            <div class="form-group row form-h mt-25p">
                                                <label for="category_id"
                                                    class="col-md-2 label-title control-label"><?php echo e(__('Category')); ?></label>
                                                <div class="col-md-10">
                                                    <input class="form-control inputFieldDesign" id="custom-show"
                                                        placeholder="<?php echo e(__('Select Category')); ?>"
                                                        value="<?php echo e($parentCategory ?? null); ?>" autocomplete="off">
                                                    <div class="Content">
                                                        <div class="d-flex">
                                                            <div class="drop-main custom-scroll shadow-sm" id="myDIV">
                                                                <ul class="Menu -vertical">
                                                                    <div class="input-group p-2">
                                                                        <input
                                                                            class="form-control border m-border input-height category-search ltr:border-end-0 rtl:border-start-0"
                                                                            type="search"
                                                                            placeholder="<?php echo e(__('Search')); ?>"
                                                                            data-seId=<?php echo e($catId); ?>>
                                                                        <span class="input-group-append input-height">
                                                                            <button
                                                                                class="btn text-secondary bg-white border input-height ltr:border-start-0 ltr:rounded-end rtl:border-end-0 rtl:rounded-start"
                                                                                type="button">
                                                                                <div class="icon-height">
                                                                                    <i class="fa fa-search"></i>
                                                                                </div>
                                                                            </button>
                                                                        </span>
                                                                    </div>
                                                                    <div class="custom-overflow"
                                                                        id="categorySearchDiv-<?php echo e($catId++); ?>">
                                                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <?php if(count($category->childrenCategories)): ?>
                                                                                <li class="-hasSubmenu category-list categorySearchDiv-<?php echo e($specificCat); ?>"
                                                                                    id="list-<?php echo e($category->id); ?>"
                                                                                    data-catId="<?php echo e($category->id); ?>"
                                                                                    data-name="<?php echo e($category->name); ?>">
                                                                                    <a
                                                                                        href="javascript:void(0)"><?php echo e(wrapIt($category->name, 20, ['columns' => 3, 'trim' => true, 'trimLength' => 25])); ?></a>
                                                                                    <ul>
                                                                                        <div class="input-group p-2">
                                                                                            <input
                                                                                                class="form-control ltr:border-end-0 rtl:border-start-0 border m-border input-height category-search"
                                                                                                type="search"
                                                                                                placeholder="<?php echo e(__('Search')); ?>"
                                                                                                data-seId=<?php echo e($catId); ?>>
                                                                                            <span
                                                                                                class="input-group-append input-height">
                                                                                                <button
                                                                                                    class="btn text-secondary bg-white ltr:border-start-0 ltr:rounded-end rtl:border-end-0 rtl:rounded-start input-height border ms-n5"
                                                                                                    type="button">
                                                                                                    <div
                                                                                                        class="icon-height">
                                                                                                        <i
                                                                                                            class="fa fa-search"></i>
                                                                                                    </div>
                                                                                                </button>
                                                                                            </span>
                                                                                        </div>
                                                                                        <div class="custom-overflow"
                                                                                            id="categorySearchDiv-<?php echo e($catId++); ?>">
                                                                                            <?php $__currentLoopData = $category->childrenCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $childCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                                <?php echo $__env->make('../admin/layouts.includes.child_category',
                                                                                                    [
                                                                                                        'child_category' => $childCategory,
                                                                                                        'catId' => $catId,
                                                                                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                                        </div>
                                                                                    </ul>
                                                                                </li>
                                                                            <?php else: ?>
                                                                                <li class="category-list clicked categorySearchDiv-<?php echo e($specificCat); ?>"
                                                                                    id="list-<?php echo e($category->id); ?>"
                                                                                    data-catId="<?php echo e($category->id); ?>"
                                                                                    data-name="<?php echo e($category->name); ?>">
                                                                                    <a
                                                                                        href="javascript:void(0)"><?php echo e(wrapIt($category->name, 20, ['columns' => 3, 'trim' => true, 'trimLength' => 25])); ?></a>
                                                                                </li>
                                                                            <?php endif; ?>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    </div>
                                                                </ul>

                                                                <nav aria-label="breadcrumb"
                                                                    class="mt-2 small current-section">
                                                                    <ol class="breadcrumb custom-breadcrumb text-sm">
                                                                        <span
                                                                            class="inline-block ltr:me-2 rtl:ms-2"><?php echo e(__('Current section')); ?>:
                                                                        </span>
                                                                    </ol>
                                                                </nav>

                                                                <div class="d-flx align-items-center">
                                                                    <a class="btn-confirms h-33p w-88p" disabled
                                                                        id="categorySubmit"><?php echo e(__('Confirm')); ?></a>
                                                                    <a class="btn-add"
                                                                        id="categoryCancel"><?php echo e(__('Cancel')); ?></a>
                                                                    <a class="f-14 color-2c ltr:ms-2 rtl:me-2 text-black cursor-pointer font-weight-500"
                                                                        id="categoryClear"><?php echo e(__('Clear')); ?></a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                        <input type="hidden" name="category_id" id="category_id"
                                            value="<?php echo e(isset($product) ? optional($product->productCategory)->category_id ?? 1 : 1); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/creativedesignbd/ecommerce9.creativedesign.com.bd/resources/views/admin/products/sections/product-basic.blade.php ENDPATH**/ ?>