<?php if(isset($product) && isset($product->attributes) && is_array($product->attributes)): ?>
    <?php $__currentLoopData = $product->attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $productAttr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="attribute-dlt" data-serial="<?php echo e($loop->index); ?>">
            <div class="d-flex justify-content-between align-items-center border-t h-40p mx-25n px-32p bg-F5 col-attr collapse-header"
                data-bs-toggle="collapse" href="#<?php echo e($unid = 'col_' . uniqid()); ?>">
                <p class="label-title m-0 ml-16n-res font-weight-600 attribute-box-title"><?php echo e($productAttr['name']); ?></p>
                <div class="d-flex align-items-center">
                    <svg class="cursor-move mt-0" width="16" height="11" viewBox="0 0 16 11" fill="none"
                        xmlns="http://www.w3.org/2000/svg">
                        <rect width="16" height="1" fill="#898989" />
                        <rect y="5" width="16" height="1" fill="#898989" />
                        <rect y="10" width="16" height="1" fill="#898989" />
                    </svg>
                    <span
                        class="toggle-btn ml-10p mt-0 d-flex h-20 w-20 align-items-center justify-content-center inactive-sec collapsed"
                        data-bs-toggle="collapse" href="#<?php echo e($unid); ?>">
                        <svg width="8" height="6" viewBox="0 0 8 6" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M4.18767 5.90789L7.81732 1.34361C8.24162 0.810056 7.87956 -1.43628e-09 7.21678 -9.33983e-09L0.783223 -8.60592e-08C0.120445 -9.39628e-08 -0.241618 0.810055 0.182683 1.34361L3.81233 5.90789C3.91 6.0307 4.09 6.0307 4.18767 5.90789Z"
                                fill="#2C2C2C" />
                        </svg>
                    </span>

                    <form method="post" action="#" accept-charset="UTF-8"
                        id="delete-attribute-<?php echo e($uniq = 'attr' . uniqid()); ?>" class="delete_attribute">
                        <?php echo e(method_field('DELETE')); ?>

                        <?php echo csrf_field(); ?>
                        <span class="f-11 red-9E ml-10p cursor-pointer" title="<?php echo e(__('Delete')); ?>"
                            class="btn btn-xs btn-danger" type="button" data-id="<?php echo e($uniq); ?>"
                            data-delete="attribute" data-label="Delete" data-bs-toggle="modal" data-bs-target="#confirmDelete"
                            data-title="<?php echo e(__('Delete :x', ['x' => __('Attribute')])); ?>"
                            data-message="<?php echo e(__('Are you sure to delete this attribute?')); ?>">
                            <?php echo e(__('Delete')); ?>

                        </span>
                    </form>
                </div>
            </div>
            <div class="collapse" id="<?php echo e($unid); ?>">
                <div class="row m-0 px-7 pb-30p">
                    <div class="col-md-3 p-0">
                        <?php if($productAttr['attribute_id']): ?>
                            <label for="Color_sec" class="control-label gray-89"><?php echo e(__('Name')); ?>:
                                <?php echo e($productAttr['name']); ?></label>
                            <input type="hidden" name="attribute_names[<?php echo e($loop->index); ?>]"
                                class="form-control attribute-name" value="<?php echo e($productAttr['name']); ?>">
                        <?php else: ?>
                            <div class="form-group mb-2 mr-2">
                                <label class="control-label gray-89"><?php echo e(__('Name')); ?>:</label>
                                <input type="text" class="form-control inputFieldDesign attribute-name"
                                    name="attribute_names[<?php echo e($loop->index); ?>]" value="<?php echo e($productAttr['name']); ?>">
                            </div>
                        <?php endif; ?>
                        <input type="hidden" name="attribute_position[<?php echo e($loop->index); ?>]"
                            value="<?php echo e($loop->index); ?>">
                        <div class="checkbox checkbox-primary d-inline p-0">
                            <input type="hidden" name="attribute_visibilities[<?php echo e($loop->index); ?>]" value="0">
                            <input type="checkbox" id="<?php echo e($cid = uniqid()); ?>"
                                <?php echo e($productAttr['visibility'] ? 'checked' : ''); ?>

                                name="attribute_visibilities[<?php echo e($loop->index); ?>]" value="1">
                            <label for="<?php echo e($cid); ?>"
                                class="crs visi-title f-12 mb-0"><?php echo e(__('Visible on the product page')); ?>

                            </label>
                        </div>

                        <div
                            class="conditional-dom not-simple-dom not-grouped-dom not-external-dom <?php echo e($product->isVariableProduct() ? '' : 'd-none'); ?>">
                            <div class="checkbox checkbox-primary d-inline p-0">
                                <input type="hidden" name="attribute_variations[<?php echo e($loop->index); ?>]" value="0">
                                <input type="checkbox" id="<?php echo e($cid = uniqid()); ?>"
                                    <?php echo e($productAttr['variation'] ? 'checked' : ''); ?> value="1"
                                    name="attribute_variations[<?php echo e($loop->index); ?>]">
                                <label for="<?php echo e($cid); ?>" class="crs visi-title f-12 mb-0">
                                    <?php echo e(__('Used for variations')); ?>

                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-7 p-0-res attr">
                        <label class="sp-title control-label text-left gray-89 mt-10-res"><?php echo e(__('Values')); ?>:</label>
                        <?php if($productAttr['attribute_id'] && count($product->attributeValues) > 0): ?>
                            <input type="hidden" value="<?php echo e($productAttr['attribute_id']); ?>" class="attr_id"
                                name="attribute_attr_id[<?php echo e($loop->index); ?>]">
                            <?php
                                $attrList = $product->attributeValues[$key];
                            ?>
                            <select name="attribute_values[<?php echo e($loop->index); ?>][]" multiple class="select2 float-none"
                                multiple data-role="tagsinput">
                                <?php $__currentLoopData = $attrList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $atrs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option <?php echo e(in_array($atrs->id, $productAttr['value']) ? 'selected' : ''); ?>

                                        value="<?php echo e($atrs->id); ?>">
                                        <?php echo e($atrs->value); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <div class="d-flx justify-content-between mt-10p">
                                <div class="d-flx">
                                    <a class="opt-select options-select px-3"><?php echo e(__('Select all')); ?></a>
                                    <a class="options-deselect options-select px-3 ltr:ms-2 rtl:me-2"><?php echo e(__('Select none')); ?></a>
                                </div>
                                <a class="options-add-two ltr:float-right ltr:ms-3 rtl:float-left rtl:me-3" href="javascript:void(0)"
                                    type="button" data-id="<?php echo e($productAttr['attribute_id']); ?>"
                                    data-delete="product"
                                    data-label="<?php echo e(__('Add new :x', ['x' => $productAttr['name']])); ?>"
                                    data-bs-toggle="modal" data-bs-target="#addAttribute"
                                    data-section="<?php echo e($unid); ?>"
                                    data-title="<?php echo e(__('New') . ' ' . $productAttr['name']); ?>"
                                    data-message="<?php echo e(__('Add new') . ' ' . $productAttr['name']); ?>">
                                    <?php echo e(__('Add')); ?>

                                </a>
                            </div>
                        <?php else: ?>
                            <textarea name="attribute_values[<?php echo e($loop->index); ?>]" class="form-control h-94p" rows="3"
                                placeholder="<?php echo e(__('List of values separated by |')); ?>"><?php echo e(implode('|', $productAttr['value'])); ?></textarea>
                        <?php endif; ?>

                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>
<?php /**PATH /home/creativedesignbd/ecommerce9.creativedesign.com.bd/resources/views/admin/products/pieces/attributes.blade.php ENDPATH**/ ?>